/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.tree.DrawTree;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.File;
import com.crowdin.client.sourcefiles.model.FileInfo;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

class FileListAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final boolean noProgress;
    private final String branchName;
    private final boolean treeView;
    private final boolean plainView;
    private final boolean isVerbose;

    public FileListAction(boolean noProgress, String branchName, boolean treeView, boolean plainView, boolean isVerbose) {
        this.noProgress = noProgress || plainView;
        this.branchName = branchName;
        this.treeView = treeView;
        this.plainView = plainView;
        this.isVerbose = isVerbose;
    }

    @Override
    public void act(Outputter out, ProjectProperties pb, ProjectClient client) {
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> client.downloadFullProject(this.branchName));
        Long branchId = Optional.ofNullable(project.getBranch()).map(Branch::getId).orElse(null);
        List list = ProjectFilesUtils.buildFilePaths(project.getDirectories(), project.getBranches(), project.getFileInfos()).entrySet().stream().filter(entry -> Objects.equals(((FileInfo)entry.getValue()).getBranchId(), branchId)).map(e -> new AbstractMap.SimpleEntry<String, FileInfo>(((String)e.getKey()).replaceAll("^[/\\\\]+", ""), (FileInfo)e.getValue())).collect(Collectors.toList());
        if (this.treeView) {
            List<String> tree = list.stream().map(Map.Entry::getKey).collect(Collectors.toList());
            DrawTree.draw(tree).forEach(out::println);
            return;
        }
        for (Map.Entry entry2 : list) {
            File file;
            if (this.plainView) {
                if (this.isVerbose) {
                    if (entry2.getValue() instanceof File) {
                        file = (File)entry2.getValue();
                        String str = ((FileInfo)entry2.getValue()).getId() + " " + (String)entry2.getKey() + " " + file.getType() + " " + file.getParserVersion() + " " + file.getRevisionId();
                        out.println(str);
                        continue;
                    }
                    out.println(String.format("%d %s %s", ((FileInfo)entry2.getValue()).getId(), entry2.getKey(), ((FileInfo)entry2.getValue()).getType()));
                    continue;
                }
                out.println(String.format("%d %s", ((FileInfo)entry2.getValue()).getId(), entry2.getKey()));
                continue;
            }
            if (this.isVerbose) {
                if (entry2.getValue() instanceof File) {
                    file = (File)entry2.getValue();
                    out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.file.list_verbose_full"), ((FileInfo)entry2.getValue()).getId(), entry2.getKey(), ((FileInfo)entry2.getValue()).getType(), file.getParserVersion(), file.getRevisionId()));
                    continue;
                }
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.file.list_verbose"), ((FileInfo)entry2.getValue()).getId(), entry2.getKey(), ((FileInfo)entry2.getValue()).getType()));
                continue;
            }
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.file.list"), ((FileInfo)entry2.getValue()).getId(), entry2.getKey()));
        }
    }
}

