/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientGlossary;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.glossaries.model.Glossary;
import com.crowdin.client.glossaries.model.Term;
import java.util.List;

class GlossaryListAction
implements NewAction<BaseProperties, ClientGlossary> {
    private final boolean isVerbose;
    private final boolean plainView;

    public GlossaryListAction(boolean plainView, boolean isVerbose) {
        this.plainView = plainView;
        this.isVerbose = isVerbose;
    }

    @Override
    public void act(Outputter out, BaseProperties pb, ClientGlossary client) {
        List<Glossary> glossaries = client.listGlossaries();
        for (Glossary glossary : glossaries) {
            if (!this.plainView) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.glossary.list"), glossary.getId(), glossary.getName(), glossary.getTerms()));
                if (!this.isVerbose || !this.mayHaveTerms(glossary)) continue;
                try {
                    List<Term> terms = client.listTerms(glossary.getId());
                    for (Term term : terms) {
                        String description = Utils.toSingleLineString(term.getDescription() != null ? term.getDescription() : "");
                        out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.glossary.list_term"), term.getId(), term.getText(), description));
                    }
                    continue;
                }
                catch (Exception e) {
                    out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("error.glossary.no_permission")));
                    continue;
                }
            }
            out.println(glossary.getName());
        }
    }

    private boolean mayHaveTerms(Glossary glossary) {
        return glossary != null && (glossary.getTerms() == null || glossary.getTerms() > 0);
    }
}

