/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientGlossary;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.glossaries.model.AddGlossaryRequest;
import com.crowdin.client.glossaries.model.Glossary;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;
import lombok.NonNull;

class GlossaryUploadAction
implements NewAction<BaseProperties, ClientGlossary> {
    private final File file;
    private final Long id;
    private final String languageId;
    private final Map<String, Integer> scheme;
    private final Boolean firstLineContainsHeader;
    private final boolean plainView;

    public GlossaryUploadAction(@NonNull File file, Long id, String languageId, Map<String, Integer> scheme, Boolean firstLineContainsHeader, boolean plainView) {
        if (file == null) {
            throw new NullPointerException("file is marked non-null but is null");
        }
        this.file = file;
        this.id = id;
        this.languageId = languageId;
        this.scheme = scheme;
        this.firstLineContainsHeader = firstLineContainsHeader;
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, BaseProperties pb, ClientGlossary client) {
        Long storageId;
        Glossary targetGlossary;
        boolean isOrganization = PropertiesBeanUtils.isOrganization(pb.getBaseUrl());
        if (this.id != null) {
            targetGlossary = client.getGlossary(this.id);
        } else {
            AddGlossaryRequest addGlossaryRequest = isOrganization ? RequestBuilder.addGlossaryEnterprise(String.format("Created in Crowdin CLI (%s)", this.file.getName()), this.languageId, 0L) : RequestBuilder.addGlossary(String.format("Created in Crowdin CLI (%s)", this.file.getName()), this.languageId);
            targetGlossary = client.addGlossary(addGlossaryRequest);
        }
        try (FileInputStream fileStream = new FileInputStream(this.file);){
            storageId = client.uploadStorage(this.file.getName(), fileStream);
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"));
        }
        client.importGlossary(targetGlossary.getId(), RequestBuilder.importGlossary(storageId, this.scheme, this.firstLineContainsHeader));
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.glossary.import_success"), targetGlossary.getId(), targetGlossary.getName())));
        } else {
            out.println(targetGlossary.getId().toString());
        }
    }
}

