/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientLabel;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.labels.model.AddLabelRequest;
import com.crowdin.client.labels.model.Label;
import java.util.Map;
import java.util.stream.Collectors;

class LabelAddAction
implements NewAction<ProjectProperties, ClientLabel> {
    private final String title;
    private final boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties properties, ClientLabel client) {
        Map<String, Long> labels = client.listLabels().stream().collect(Collectors.toMap(Label::getTitle, Label::getId));
        if (!labels.containsKey(this.title)) {
            AddLabelRequest request = new AddLabelRequest();
            request.setTitle(this.title);
            Label label = client.addLabel(request);
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.label.list"), label.getId(), label.getTitle())));
            } else {
                out.println(this.title);
            }
        } else if (!this.plainView) {
            out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.label.already_exists"), this.title)));
        } else {
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.label_already_exists"), this.title));
        }
    }

    public LabelAddAction(String title, boolean plainView) {
        this.title = title;
        this.plainView = plainView;
    }
}

