/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientLabel;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.labels.model.Label;
import java.util.Map;
import java.util.stream.Collectors;

class LabelDeleteAction
implements NewAction<ProjectProperties, ClientLabel> {
    private final String title;

    @Override
    public void act(Outputter out, ProjectProperties properties, ClientLabel client) {
        Map<String, Long> labels = client.listLabels().stream().collect(Collectors.toMap(Label::getTitle, Label::getId));
        if (!labels.containsKey(this.title)) {
            throw new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.label.not_found"));
        }
        client.deleteLabel(labels.get(this.title));
        out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.label.deleted"), this.title)));
    }

    public LabelDeleteAction(String title) {
        this.title = title;
    }
}

