/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectInfo;
import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.languages.model.Language;
import java.util.List;

class LanguageListAction
implements NewAction<ProjectProperties, ProjectClient> {
    private BaseCli.LanguageCode code;
    private boolean all;
    private boolean noProgress;
    private boolean plainView;

    public LanguageListAction(BaseCli.LanguageCode code, boolean all, boolean noProgress, boolean plainView) {
        this.code = code != null ? code : BaseCli.LanguageCode.id;
        this.all = all;
        this.noProgress = noProgress || plainView;
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        List<Language> languages;
        CrowdinProjectInfo project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, client::downloadProjectInfo);
        if (!project.isManagerAccess()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access")));
                return;
            }
            throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access"));
        }
        LanguageMapping langMapping = project.getLanguageMapping();
        List<Language> list = languages = this.all ? client.listSupportedLanguages() : project.getProjectLanguages(true);
        if (!this.plainView) {
            languages.stream().map(lang -> String.format(BaseCli.RESOURCE_BUNDLE.getString("message.language.list"), this.getCode(langMapping, (Language)lang), lang.getName())).forEach(out::println);
        } else {
            languages.stream().map(lang -> this.getCode(langMapping, (Language)lang)).forEach(out::println);
        }
    }

    private String getCode(LanguageMapping langMapping, Language language) {
        switch (this.code) {
            case three_letters_code: {
                return langMapping.getValueOrDefault(language.getId(), "%three_letters_code%".replaceAll("%", ""), language.getThreeLettersCode());
            }
            case android_code: {
                return langMapping.getValueOrDefault(language.getId(), "%android_code%".replaceAll("%", ""), language.getAndroidCode());
            }
            case locale: {
                return langMapping.getValueOrDefault(language.getId(), "%locale%".replaceAll("%", ""), language.getLocale());
            }
            case osx_code: {
                return langMapping.getValueOrDefault(language.getId(), "%osx_code%".replaceAll("%", ""), language.getOsxCode());
            }
            case osx_locale: {
                return langMapping.getValueOrDefault(language.getId(), "%osx_locale%".replaceAll("%", ""), language.getOsxLocale());
            }
            case two_letters_code: {
                return langMapping.getValueOrDefault(language.getId(), "%two_letters_code%".replaceAll("%", ""), language.getTwoLettersCode());
            }
        }
        return language.getId();
    }
}

