/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.projectsgroups.model.AddProjectRequest;
import com.crowdin.client.projectsgroups.model.Project;
import com.crowdin.client.projectsgroups.model.Visibility;
import java.util.List;
import java.util.Objects;

class ProjectAddAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final String name;
    private final boolean isStringBased;
    private final String sourceLanguage;
    private final List<String> languages;
    private final boolean isPublic;
    private final boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        String sourceLang;
        boolean isOrganization = PropertiesBeanUtils.isOrganization(properties.getBaseUrl());
        String string = sourceLang = Objects.nonNull(this.sourceLanguage) ? this.sourceLanguage : "en";
        Visibility visibility = isOrganization ? null : (this.isPublic ? Visibility.OPEN : Visibility.PRIVATE);
        AddProjectRequest request = RequestBuilder.addProject(this.name, this.isStringBased, sourceLang, this.languages, visibility, isOrganization);
        Project project = client.addProject(request);
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.project.list"), project.getId(), project.getName())));
        } else {
            out.println(project.getId().toString());
        }
    }

    public ProjectAddAction(String name, boolean isStringBased, String sourceLanguage, List<String> languages, boolean isPublic, boolean plainView) {
        this.name = name;
        this.isStringBased = isStringBased;
        this.sourceLanguage = sourceLanguage;
        this.languages = languages;
        this.isPublic = isPublic;
        this.plainView = plainView;
    }
}

