/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.client.projectsgroups.model.Project;
import com.crowdin.client.projectsgroups.model.Type;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Optional;

class ProjectListAction
implements NewAction<ProjectProperties, ProjectClient> {
    private final boolean isVerbose;

    @Override
    public void act(Outputter out, ProjectProperties properties, ProjectClient client) {
        List<? extends Project> projects = client.listProjects();
        for (Project project : projects) {
            if (!this.isVerbose) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.project.list"), project.getId(), project.getName()));
                continue;
            }
            String lastActivity = DateTimeFormatter.ISO_DATE_TIME.format(project.getLastActivity().toInstant().atOffset(ZoneOffset.UTC));
            String visibility = Optional.ofNullable(project.getVisibility()).orElse("private");
            String type = Optional.ofNullable(project.getType()).filter(t -> t == Type.STRINGS_BASED).map(t -> "string-based").orElse("file-based");
            out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.project.list.verbose"), project.getId(), project.getName(), type, visibility, lastActivity));
        }
    }

    public ProjectListAction(boolean isVerbose) {
        this.isVerbose = isVerbose;
    }
}

