/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientScreenshot;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.screenshots.model.Screenshot;
import java.util.List;

class ScreenshotListAction
implements NewAction<ProjectProperties, ClientScreenshot> {
    private final Long stringId;
    private final boolean plainView;

    public ScreenshotListAction(Long stringId, boolean plainView) {
        this.stringId = stringId;
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, ProjectProperties properties, ClientScreenshot client) {
        List<Screenshot> screenshots = client.listScreenshots(this.stringId);
        for (Screenshot screenshot : screenshots) {
            if (!this.plainView) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.screenshot.list"), screenshot.getId(), screenshot.getTagsCount(), screenshot.getName()));
                continue;
            }
            out.println(String.format("%d %s", screenshot.getId(), screenshot.getName()));
        }
        if (screenshots.isEmpty()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.screenshot.list_empty")));
            } else {
                out.println(BaseCli.RESOURCE_BUNDLE.getString("message.screenshot.list_empty"));
            }
        }
    }
}

