/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientTask;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.commands.picocli.GenericActCommand;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.tasks.model.AddTaskRequest;
import com.crowdin.client.tasks.model.CreateTaskEnterpriseRequest;
import com.crowdin.client.tasks.model.CreateTaskRequest;
import com.crowdin.client.tasks.model.Task;
import com.crowdin.client.tasks.model.Type;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;

class TaskAddAction
implements NewAction<ProjectProperties, ClientTask> {
    private boolean noProgress;
    private String title;
    private Integer type;
    private String language;
    private List<String> files;
    private String branch;
    private Long workflowStep;
    private String description;
    private Boolean skipAssignedStrings;
    private Boolean includePreTranslatedStringsOnly;
    private List<Long> labels;
    private boolean plainView;

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientTask client) {
        AddTaskRequest addTaskRequest;
        ProjectClient projectClient = GenericActCommand.getProjectClient(pb);
        boolean isOrganization = PropertiesBeanUtils.isOrganization(pb.getBaseUrl());
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> projectClient.downloadFullProject(this.branch));
        ArrayList<Long> fileIds = new ArrayList<Long>();
        Map<String, FileInfo> paths = ProjectFilesUtils.buildFilePaths(project.getDirectories(), project.getBranches(), project.getFileInfos());
        for (String file : this.files) {
            String path = Utils.normalizePath(Utils.noSepAtStart(file));
            if (paths.containsKey(path)) {
                fileIds.add(paths.get(path).getId());
                continue;
            }
            out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.file_not_exists"), path)));
        }
        if (fileIds.isEmpty()) {
            throw new ExitCodeExceptionMapper.ValidationException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.task.no_valid_file"), new Object[0]));
        }
        if (isOrganization) {
            addTaskRequest = new CreateTaskEnterpriseRequest();
            Optional.ofNullable(this.title).ifPresent(value -> ((CreateTaskEnterpriseRequest)addTaskRequest).setTitle((String)value));
            Optional.ofNullable(this.language).ifPresent(value -> ((CreateTaskEnterpriseRequest)addTaskRequest).setLanguageId((String)value));
            Optional.ofNullable(fileIds).ifPresent(value -> ((CreateTaskEnterpriseRequest)addTaskRequest).setFileIds((List<Long>)value));
            Optional.ofNullable(this.description).ifPresent(value -> ((CreateTaskEnterpriseRequest)addTaskRequest).setDescription((String)value));
            Optional.ofNullable(this.skipAssignedStrings).ifPresent(value -> ((CreateTaskEnterpriseRequest)addTaskRequest).setSkipAssignedStrings((Boolean)value));
            Optional.ofNullable(this.includePreTranslatedStringsOnly).ifPresent(value -> ((CreateTaskEnterpriseRequest)addTaskRequest).setIncludePreTranslatedStringsOnly((Boolean)value));
            Optional.ofNullable(this.labels).ifPresent(value -> ((CreateTaskEnterpriseRequest)addTaskRequest).setLabelIds((List<Long>)value));
            Optional.ofNullable(this.workflowStep).ifPresent(value -> ((CreateTaskEnterpriseRequest)addTaskRequest).setWorkflowStepId((Long)value));
        } else {
            addTaskRequest = new CreateTaskRequest();
            Optional.ofNullable(this.title).ifPresent(value -> ((CreateTaskRequest)addTaskRequest).setTitle((String)value));
            Optional.ofNullable(this.type).ifPresent(value -> ((CreateTaskRequest)addTaskRequest).setType(Type.from(String.valueOf(value))));
            Optional.ofNullable(this.language).ifPresent(value -> ((CreateTaskRequest)addTaskRequest).setLanguageId((String)value));
            Optional.ofNullable(fileIds).ifPresent(value -> ((CreateTaskRequest)addTaskRequest).setFileIds((List<Long>)value));
            Optional.ofNullable(this.description).ifPresent(value -> ((CreateTaskRequest)addTaskRequest).setDescription((String)value));
            Optional.ofNullable(this.skipAssignedStrings).ifPresent(value -> ((CreateTaskRequest)addTaskRequest).setSkipAssignedStrings((Boolean)value));
            Optional.ofNullable(this.includePreTranslatedStringsOnly).ifPresent(value -> ((CreateTaskRequest)addTaskRequest).setIncludePreTranslatedStringsOnly((Boolean)value));
            Optional.ofNullable(this.labels).ifPresent(value -> ((CreateTaskRequest)addTaskRequest).setLabelIds((List<Long>)value));
        }
        try {
            String deadline;
            Task task = client.addTask(addTaskRequest);
            String string = deadline = task.getDeadline() == null ? "NoDueDate" : task.getDeadline().toString();
            if (!this.plainView) {
                out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.task.list"), task.getId(), task.getTargetLanguageId(), task.getTitle(), task.getStatus(), task.getWordsCount(), deadline)));
            } else {
                out.println(String.format("%d %s", task.getId(), task.getTitle()));
            }
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.task_is_not_added"), addTaskRequest));
        }
    }

    public TaskAddAction(boolean noProgress, String title, Integer type, String language, List<String> files, String branch, Long workflowStep, String description, Boolean skipAssignedStrings, Boolean includePreTranslatedStringsOnly, List<Long> labels, boolean plainView) {
        this.noProgress = noProgress;
        this.title = title;
        this.type = type;
        this.language = language;
        this.files = files;
        this.branch = branch;
        this.workflowStep = workflowStep;
        this.description = description;
        this.skipAssignedStrings = skipAssignedStrings;
        this.includePreTranslatedStringsOnly = includePreTranslatedStringsOnly;
        this.labels = labels;
        this.plainView = plainView;
    }
}

