/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientTask;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.tasks.model.Status;
import com.crowdin.client.tasks.model.Task;
import java.util.List;
import java.util.stream.Collectors;

class TaskListAction
implements NewAction<ProjectProperties, ClientTask> {
    private final boolean plainView;
    private final boolean isVerbose;
    private final String status;
    private final Long assigneeId;

    @Override
    public void act(Outputter out, ProjectProperties pb, ClientTask client) {
        Status sts = this.status == null ? null : Status.valueOf(this.status.toUpperCase());
        List<Task> tasks = client.listTask(sts);
        if (this.assigneeId != null) {
            tasks = tasks.stream().filter(task -> task.getAssignees().stream().anyMatch(assignee -> assignee.getId().equals(this.assigneeId))).collect(Collectors.toList());
        }
        for (Task task2 : tasks) {
            String deadline;
            String okMessage = this.isVerbose ? "message.task.list.verbose" : "message.task.list";
            String string = deadline = task2.getDeadline() == null ? "NoDueDate" : task2.getDeadline().toString();
            if (!this.plainView) {
                out.println(String.format(BaseCli.RESOURCE_BUNDLE.getString(okMessage), task2.getId(), task2.getTargetLanguageId(), task2.getTitle(), task2.getStatus(), task2.getWordsCount(), deadline));
                continue;
            }
            out.println(String.format("%d %s", task2.getId(), task2.getTitle()));
        }
        if (tasks.isEmpty() && !this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.task.list_empty")));
        }
    }

    public TaskListAction(boolean plainView, boolean isVerbose, String status, Long assigneeId) {
        this.plainView = plainView;
        this.isVerbose = isVerbose;
        this.status = status;
        this.assigneeId = assigneeId;
    }
}

