/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.ClientTm;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.translationmemory.model.AddTranslationMemoryRequest;
import com.crowdin.client.translationmemory.model.TranslationMemory;
import java.io.File;
import java.io.FileInputStream;
import java.util.Map;

class TmUploadAction
implements NewAction<BaseProperties, ClientTm> {
    private final File file;
    private final Long id;
    private final String languageId;
    private final Map<String, Integer> scheme;
    private final Boolean firstLineContainsHeader;
    private final boolean plainView;

    @Override
    public void act(Outputter out, BaseProperties pb, ClientTm client) {
        Long storageId;
        boolean isOrganization = PropertiesBeanUtils.isOrganization(pb.getBaseUrl());
        TranslationMemory targetTm = this.getTm(client, isOrganization);
        try (FileInputStream fileStream = new FileInputStream(this.file);){
            storageId = client.uploadStorage(this.file.getName(), fileStream);
        }
        catch (Exception e) {
            throw ExitCodeExceptionMapper.remap(e, BaseCli.RESOURCE_BUNDLE.getString("error.upload_to_storage"));
        }
        client.importTm(targetTm.getId(), RequestBuilder.importTranslationMemory(storageId, this.scheme, this.firstLineContainsHeader));
        if (!this.plainView) {
            out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.tm.import_success"), targetTm.getId(), targetTm.getName())));
        } else {
            out.println(targetTm.getId().toString());
        }
    }

    private TranslationMemory getTm(ClientTm client, boolean isEnterprise) {
        if (this.id != null) {
            return client.getTm(this.id);
        }
        AddTranslationMemoryRequest addTmRequest = isEnterprise ? RequestBuilder.addTmEnterprise(String.format("Created in Crowdin CLI (%s)", this.file.getName()), this.languageId, 0L) : RequestBuilder.addTm(String.format("Created in Crowdin CLI (%s)", this.file.getName()), this.languageId);
        return client.addTm(addTmRequest);
    }

    public TmUploadAction(File file, Long id, String languageId, Map<String, Integer> scheme, Boolean firstLineContainsHeader, boolean plainView) {
        this.file = file;
        this.id = id;
        this.languageId = languageId;
        this.scheme = scheme;
        this.firstLineContainsHeader = firstLineContainsHeader;
        this.plainView = plainView;
    }
}

