/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.actions;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.client.CrowdinProjectFull;
import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.client.WrongLanguageException;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.BranchUtils;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.RequestBuilder;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.commands.functionality.TranslationsUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.FileBean;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.concurrency.ConcurrencyUtil;
import com.crowdin.cli.utils.console.ConsoleSpinner;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.client.languages.model.Language;
import com.crowdin.client.projectsgroups.model.Type;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.translations.model.UploadTranslationsRequest;
import com.crowdin.client.translations.model.UploadTranslationsStringsRequest;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

class UploadTranslationsAction
implements NewAction<PropertiesWithFiles, ProjectClient> {
    private boolean noProgress;
    private String languageId;
    private String branchName;
    private boolean importEqSuggestions;
    private boolean autoApproveImported;
    private boolean translateHidden;
    private boolean debug;
    private boolean plainView;

    public UploadTranslationsAction(boolean noProgress, String languageId, String branchName, boolean importEqSuggestions, boolean autoApproveImported, boolean translateHidden, boolean debug, boolean plainView) {
        this.noProgress = noProgress || plainView;
        this.languageId = languageId;
        this.branchName = branchName;
        this.importEqSuggestions = importEqSuggestions;
        this.autoApproveImported = autoApproveImported;
        this.translateHidden = translateHidden;
        this.debug = debug;
        this.plainView = plainView;
    }

    @Override
    public void act(Outputter out, PropertiesWithFiles pb, ProjectClient client) {
        CrowdinProjectFull project = ConsoleSpinner.execute(out, "message.spinner.fetching_project_info", "error.collect_project_info", this.noProgress, this.plainView, () -> client.downloadFullProject(this.branchName));
        boolean isStringsBasedProject = Objects.equals(project.getType(), Type.STRINGS_BASED);
        if (!project.isManagerAccess()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.WARNING.withIcon(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access")));
                return;
            }
            throw new ExitCodeExceptionMapper.ForbiddenException(BaseCli.RESOURCE_BUNDLE.getString("message.no_manager_access"));
        }
        PlaceholderUtil placeholderUtil = new PlaceholderUtil(project.getSupportedLanguages(), project.getProjectLanguages(true), pb.getBasePath());
        LanguageMapping serverLanguageMapping = project.getLanguageMapping();
        List languages = this.languageId != null ? project.findLanguageById(this.languageId, true).map(Collections::singletonList).orElseThrow(() -> new RuntimeException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.language_not_exist"), this.languageId))) : project.getProjectLanguages(false);
        for (FileBean file : pb.getFiles()) {
            String commonPath;
            List<String> fileSourcesWithoutIgnores = SourcesUtils.getFiles(pb.getBasePath(), file.getSource(), file.getIgnore(), placeholderUtil).map(File::getAbsolutePath).collect(Collectors.toList());
            String string = commonPath = pb.getPreserveHierarchy() != false ? "" : SourcesUtils.getCommonPath(fileSourcesWithoutIgnores, pb.getBasePath());
            if (fileSourcesWithoutIgnores.isEmpty()) {
                if (this.plainView) continue;
                out.println(ExecutionStatus.ERROR.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.no_sources"), file.getSource())));
                continue;
            }
            List<Runnable> tasks = null;
            AtomicBoolean containsErrors = new AtomicBoolean(false);
            if (!isStringsBasedProject) {
                Map<String, com.crowdin.client.sourcefiles.model.File> paths = ProjectFilesUtils.buildFilePaths(project.getDirectories(), project.getBranches(), project.getFiles());
                HashMap preparedRequests = new HashMap();
                String branchPath = StringUtils.isNotEmpty(this.branchName) ? BranchUtils.normalizeBranchName(this.branchName) + Utils.PATH_SEPARATOR : "";
                fileSourcesWithoutIgnores.forEach(source -> {
                    String filePath = branchPath + (StringUtils.isNotEmpty(file.getDest()) ? PropertiesBeanUtils.prepareDest(file.getDest(), StringUtils.removeStart(source, pb.getBasePath()), placeholderUtil) : StringUtils.removeStart(source, pb.getBasePath() + commonPath));
                    Map.Entry sourceFile = ProjectFilesUtils.fileLookup(filePath, paths);
                    if (sourceFile == null) {
                        containsErrors.set(true);
                        if (!this.plainView) {
                            out.println(ExecutionStatus.ERROR.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.source_not_exists_in_project"), StringUtils.removeStart(source, pb.getBasePath()), filePath)));
                        }
                        return;
                    }
                    Long fileId = ((com.crowdin.client.sourcefiles.model.File)sourceFile.getKey()).getId();
                    String fileSource = StringUtils.removeStart(source, pb.getBasePath());
                    String translation = TranslationsUtils.replaceDoubleAsterisk(file.getSource(), file.getTranslation(), fileSource);
                    translation = placeholderUtil.replaceFileDependentPlaceholders(translation, new File((String)source));
                    if (file.getScheme() != null && !PlaceholderUtil.containsLangPlaceholders(translation)) {
                        File transFile = this.getTranslationFile(out, pb, translation);
                        if (Objects.isNull(transFile)) {
                            return;
                        }
                        UploadTranslationsRequest request = RequestBuilder.uploadTranslations(fileId, this.importEqSuggestions, this.autoApproveImported, this.translateHidden);
                        preparedRequests.put(transFile, Pair.of(languages, request));
                    } else {
                        for (Language language : languages) {
                            File transFile = this.getTranslationFileWithPlaceholders(out, pb, placeholderUtil, serverLanguageMapping, file, translation, language);
                            if (Objects.isNull(transFile)) continue;
                            UploadTranslationsRequest request = RequestBuilder.uploadTranslations(fileId, this.importEqSuggestions, this.autoApproveImported, this.translateHidden);
                            preparedRequests.put(transFile, Pair.of(Collections.singletonList(language), request));
                        }
                    }
                });
                tasks = preparedRequests.entrySet().stream().map(entry -> () -> {
                    File translationFile = (File)entry.getKey();
                    List langs = (List)((Pair)entry.getValue()).getLeft();
                    UploadTranslationsRequest request = (UploadTranslationsRequest)((Pair)entry.getValue()).getRight();
                    request.setStorageId(this.uploadToStorage(pb, client, containsErrors, translationFile));
                    try {
                        for (Language lang : langs) {
                            try {
                                client.uploadTranslations(lang.getId(), request);
                            }
                            catch (WrongLanguageException e) {
                                out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.warning.file_not_uploaded_cause_of_language"), StringUtils.removeStart(translationFile.getAbsolutePath(), pb.getBasePath()), lang.getName())));
                            }
                        }
                    }
                    catch (Exception e) {
                        containsErrors.set(true);
                        throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_translation"), StringUtils.removeStart(translationFile.getAbsolutePath(), pb.getBasePath())));
                    }
                    if (!this.plainView) {
                        out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), StringUtils.removeStart(translationFile.getAbsolutePath(), pb.getBasePath()))));
                    } else {
                        out.println(StringUtils.removeStart(translationFile.getAbsolutePath(), pb.getBasePath()));
                    }
                }).collect(Collectors.toList());
            } else {
                HashMap preparedRequests = new HashMap();
                Branch branch = project.findBranchByName(this.branchName).orElseThrow(() -> new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.branch_required_string_project")));
                fileSourcesWithoutIgnores.forEach(source -> {
                    String fileSource = StringUtils.removeStart(source, pb.getBasePath());
                    String translation = TranslationsUtils.replaceDoubleAsterisk(file.getSource(), file.getTranslation(), fileSource);
                    translation = placeholderUtil.replaceFileDependentPlaceholders(translation, new File((String)source));
                    if (file.getScheme() != null && !PlaceholderUtil.containsLangPlaceholders(translation)) {
                        File transFile = this.getTranslationFile(out, pb, translation);
                        if (Objects.isNull(transFile)) {
                            return;
                        }
                        UploadTranslationsStringsRequest request = RequestBuilder.uploadTranslationsStrings(branch.getId(), this.importEqSuggestions, this.autoApproveImported, this.translateHidden);
                        preparedRequests.put(transFile, Pair.of(languages, request));
                    } else {
                        for (Language language : languages) {
                            File transFile = this.getTranslationFileWithPlaceholders(out, pb, placeholderUtil, serverLanguageMapping, file, translation, language);
                            if (Objects.isNull(transFile)) continue;
                            UploadTranslationsStringsRequest request = RequestBuilder.uploadTranslationsStrings(branch.getId(), this.importEqSuggestions, this.autoApproveImported, this.translateHidden);
                            preparedRequests.put(transFile, Pair.of(Collections.singletonList(language), request));
                        }
                    }
                });
                tasks = preparedRequests.entrySet().stream().map(entry -> () -> {
                    File translationFile = (File)entry.getKey();
                    List langs = (List)((Pair)entry.getValue()).getLeft();
                    UploadTranslationsStringsRequest request = (UploadTranslationsStringsRequest)((Pair)entry.getValue()).getRight();
                    request.setStorageId(this.uploadToStorage(pb, client, containsErrors, translationFile));
                    try {
                        for (Language lang : langs) {
                            client.uploadTranslationStringsBased(lang.getId(), request);
                        }
                    }
                    catch (Exception e) {
                        containsErrors.set(true);
                        throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_translation"), StringUtils.removeStart(translationFile.getAbsolutePath(), pb.getBasePath())));
                    }
                    if (!this.plainView) {
                        out.println(ExecutionStatus.OK.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.uploading_file"), StringUtils.removeStart(translationFile.getAbsolutePath(), pb.getBasePath()))));
                    } else {
                        out.println(StringUtils.removeStart(translationFile.getAbsolutePath(), pb.getBasePath()));
                    }
                }).collect(Collectors.toList());
            }
            if (isStringsBasedProject) {
                ConcurrencyUtil.executeAndWaitSingleThread(tasks, this.debug);
            } else {
                ConcurrencyUtil.executeAndWait(tasks, this.debug);
            }
            if (!containsErrors.get()) continue;
            throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.execution_contains_errors"));
        }
    }

    private Long uploadToStorage(PropertiesWithFiles pb, ProjectClient client, AtomicBoolean containsErrors, File translationFile) {
        Long l;
        FileInputStream fileStream = new FileInputStream(translationFile);
        try {
            Long storageId;
            l = storageId = client.uploadStorage(translationFile.getName(), fileStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)fileStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                containsErrors.set(true);
                throw ExitCodeExceptionMapper.remap(e, String.format(BaseCli.RESOURCE_BUNDLE.getString("error.upload_translation_to_storage"), StringUtils.removeStart(translationFile.getAbsolutePath(), pb.getBasePath())));
            }
        }
        ((InputStream)fileStream).close();
        return l;
    }

    private File getTranslationFileWithPlaceholders(Outputter out, PropertiesWithFiles pb, PlaceholderUtil placeholderUtil, LanguageMapping serverLanguageMapping, FileBean file, String translation, Language language) {
        LanguageMapping localLanguageMapping = LanguageMapping.fromConfigFileLanguageMapping(file.getLanguagesMapping());
        LanguageMapping languageMapping = LanguageMapping.populate(localLanguageMapping, serverLanguageMapping);
        String transFileName = placeholderUtil.replaceLanguageDependentPlaceholders(translation, languageMapping, language);
        transFileName = PropertiesBeanUtils.useTranslationReplace(transFileName, file.getTranslationReplace());
        return this.getTranslationFile(out, pb, transFileName);
    }

    private File getTranslationFile(Outputter out, PropertiesWithFiles pb, String translation) {
        File transFile = new File(pb.getBasePath() + Utils.PATH_SEPARATOR + translation);
        if (!transFile.exists()) {
            if (!this.plainView) {
                out.println(ExecutionStatus.SKIPPED.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.translation_not_exists"), StringUtils.removeStart(transFile.getAbsolutePath(), pb.getBasePath()))));
            }
            return null;
        }
        return transFile;
    }
}

