/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.commands.functionality.Dryrun;
import com.crowdin.cli.commands.functionality.ObsoleteSourcesUtils;
import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.properties.FileBean;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.client.sourcefiles.model.Directory;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class DryrunObsoleteSources
extends Dryrun {
    private PropertiesWithFiles pb;
    private PlaceholderUtil placeholderUtil;
    private Map<Long, Directory> directories;
    private List<com.crowdin.client.sourcefiles.model.File> files;

    public DryrunObsoleteSources(@NonNull PropertiesWithFiles pb, @NonNull PlaceholderUtil placeholderUtil, @NonNull Map<Long, Directory> directories, @NonNull List<com.crowdin.client.sourcefiles.model.File> files) {
        super("message.delete_obsolete.obsolete_file_delete");
        if (pb == null) {
            throw new NullPointerException("pb is marked non-null but is null");
        }
        if (placeholderUtil == null) {
            throw new NullPointerException("placeholderUtil is marked non-null but is null");
        }
        if (directories == null) {
            throw new NullPointerException("directories is marked non-null but is null");
        }
        if (files == null) {
            throw new NullPointerException("files is marked non-null but is null");
        }
        this.pb = pb;
        this.placeholderUtil = placeholderUtil;
        this.directories = directories;
        this.files = files;
    }

    @Override
    protected List<String> getFiles() {
        Map<String, com.crowdin.client.sourcefiles.model.File> projectFiles = ProjectFilesUtils.buildFilePaths(this.directories, this.files);
        ArrayList<String> obsoleteFilesResult = new ArrayList<String>();
        for (FileBean file : this.pb.getFiles()) {
            String pattern;
            List<String> sources = SourcesUtils.getFiles(this.pb.getBasePath(), file.getSource(), file.getIgnore(), this.placeholderUtil).map(File::getAbsolutePath).collect(Collectors.toList());
            String commonPath = this.pb.getPreserveHierarchy() != false ? "" : SourcesUtils.getCommonPath(sources, this.pb.getBasePath());
            List<String> filesToUpdate = sources.stream().map(source -> file.getDest() != null ? PropertiesBeanUtils.prepareDest(file.getDest(), StringUtils.removeStart(source, this.pb.getBasePath()), this.placeholderUtil) : StringUtils.removeStart(source, this.pb.getBasePath() + commonPath)).map(Utils::noSepAtStart).collect(Collectors.toList());
            String string = pattern = file.getDest() != null ? file.getDest() : file.getSource();
            if (file.getDest() != null) {
                pattern = PropertiesBeanUtils.prepareDest(file.getDest(), StringUtils.removeStart(file.getSource(), this.pb.getBasePath()), this.placeholderUtil);
            }
            List<String> ignorePatterns = file.getDest() != null ? null : file.getIgnore();
            Map<String, com.crowdin.client.sourcefiles.model.File> obsoleteFiles = ObsoleteSourcesUtils.findObsoleteProjectFiles(projectFiles, this.pb.getPreserveHierarchy(), filesToUpdate, pattern, file.getTranslation(), ignorePatterns);
            obsoleteFilesResult.addAll(obsoleteFiles.keySet());
        }
        return obsoleteFilesResult;
    }
}

