/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.commands.functionality.Dryrun;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import java.io.File;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DryrunSources
extends Dryrun {
    private PropertiesWithFiles pb;
    private PlaceholderUtil placeholderUtil;

    public DryrunSources(PropertiesWithFiles pb, PlaceholderUtil placeholderUtil) {
        super("message.uploading_file");
        this.pb = pb;
        this.placeholderUtil = placeholderUtil;
    }

    @Override
    protected List<String> getFiles() {
        List<String> files = this.pb.getFiles().stream().flatMap(file -> SourcesUtils.getFiles(this.pb.getBasePath(), file.getSource(), file.getIgnore(), this.placeholderUtil).map(File::getAbsolutePath)).collect(Collectors.toList());
        String commonPath = this.pb.getPreserveHierarchy() != false ? "" : SourcesUtils.getCommonPath(files, this.pb.getBasePath());
        return files.stream().map(source -> StringUtils.removeStart(source, this.pb.getBasePath())).map(source -> StringUtils.removeStart(source, commonPath)).collect(Collectors.toList());
    }
}

