/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.commands.functionality.Dryrun;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.commands.functionality.TranslationsUtils;
import com.crowdin.cli.properties.PropertiesWithFiles;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import com.crowdin.client.languages.model.Language;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DryrunTranslations
extends Dryrun {
    private PropertiesWithFiles pb;
    private PlaceholderUtil placeholderUtil;
    private boolean filesMustExist;
    private LanguageMapping projectLanguageMapping;
    private List<Language> languages;
    private Map<String, com.crowdin.client.sourcefiles.model.File> projectSources;
    private boolean useServerSources;

    public DryrunTranslations(PropertiesWithFiles pb, LanguageMapping projectLanguageMapping, PlaceholderUtil placeholderUtil, List<Language> languages, boolean filesMustExist, Map<String, com.crowdin.client.sourcefiles.model.File> projectSources, boolean useServerSources, boolean isUpload) {
        super(isUpload ? "message.uploading_file" : "message.file_path");
        this.pb = pb;
        this.placeholderUtil = placeholderUtil;
        this.filesMustExist = filesMustExist;
        this.projectLanguageMapping = projectLanguageMapping;
        this.languages = languages;
        this.projectSources = projectSources;
        this.useServerSources = useServerSources;
    }

    @Override
    protected List<String> getFiles() {
        return this.pb.getFiles().stream().flatMap(fileBean -> {
            List foundSources = SourcesUtils.getFiles(this.pb.getBasePath(), fileBean.getSource(), fileBean.getIgnore(), this.placeholderUtil).collect(Collectors.toList());
            if (this.useServerSources) {
                String searchPattern = fileBean.getDest() != null ? fileBean.getDest() : fileBean.getSource();
                List serverSources = SourcesUtils.filterProjectFiles(new ArrayList<String>(this.projectSources.keySet()), searchPattern, fileBean.getIgnore(), this.pb.getPreserveHierarchy(), this.placeholderUtil).stream().map(s -> new File(Utils.joinPaths(this.pb.getBasePath(), s))).filter(s -> !foundSources.contains(s)).collect(Collectors.toList());
                foundSources.addAll(serverSources);
            }
            return foundSources.stream().flatMap(source -> {
                String fileSource = StringUtils.removeStart(source.getAbsolutePath(), this.pb.getBasePath());
                String translation = TranslationsUtils.replaceDoubleAsterisk(fileBean.getSource(), fileBean.getTranslation(), fileSource);
                String translation2 = this.placeholderUtil.replaceFileDependentPlaceholders(translation, (File)source);
                LanguageMapping localLanguageMapping = LanguageMapping.fromConfigFileLanguageMapping(fileBean.getLanguagesMapping());
                LanguageMapping languageMapping = LanguageMapping.populate(localLanguageMapping, this.projectLanguageMapping);
                com.crowdin.client.sourcefiles.model.File projectSource = this.projectSources.get(fileSource);
                return this.languages.stream().filter(l -> this.containsExcludedLanguage(projectSource, (Language)l)).map(l -> this.placeholderUtil.replaceLanguageDependentPlaceholders(translation2, languageMapping, (Language)l)).map(file -> PropertiesBeanUtils.useTranslationReplace(file, fileBean.getTranslationReplace()));
            });
        }).distinct().filter(file -> !this.filesMustExist || new File(this.pb.getBasePath() + StringUtils.removeStart(file, Utils.PATH_SEPARATOR)).exists()).map(source -> StringUtils.removeStart(source, this.pb.getBasePath())).collect(Collectors.toList());
    }

    private boolean containsExcludedLanguage(com.crowdin.client.sourcefiles.model.File sourceFile, Language language) {
        return sourceFile == null || sourceFile.getExcludedTargetLanguages() == null || !sourceFile.getExcludedTargetLanguages().contains(language.getId());
    }
}

