/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.commands.functionality.ProjectFilesUtils;
import com.crowdin.cli.utils.Utils;
import com.crowdin.client.sourcefiles.model.File;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import lombok.NonNull;

public class ObsoleteSourcesUtils {
    public static Map<String, File> findObsoleteProjectFiles(@NonNull Map<String, File> projectFiles, boolean preserveHierarchy, @NonNull List<String> filesToUpload, @NonNull String sourcePattern, @NonNull String exportPattern, List<String> ignorePatterns) {
        if (projectFiles == null) {
            throw new NullPointerException("projectFiles is marked non-null but is null");
        }
        if (filesToUpload == null) {
            throw new NullPointerException("filesToUpload is marked non-null but is null");
        }
        if (sourcePattern == null) {
            throw new NullPointerException("sourcePattern is marked non-null but is null");
        }
        if (exportPattern == null) {
            throw new NullPointerException("exportPattern is marked non-null but is null");
        }
        Predicate<String> patternCheck = ProjectFilesUtils.isProjectFilePathSatisfiesPatterns(sourcePattern, ignorePatterns, preserveHierarchy);
        return projectFiles.entrySet().stream().filter(entry -> patternCheck.test((String)entry.getKey())).filter(entry -> ObsoleteSourcesUtils.checkExportPattern(exportPattern, (File)entry.getValue(), preserveHierarchy)).filter(entry -> ObsoleteSourcesUtils.isFileNotInList(filesToUpload, (String)entry.getKey(), preserveHierarchy)).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static boolean checkExportPattern(String exportPattern, File file, boolean preserveHierarchy) {
        String fileExportPattern = ProjectFilesUtils.getExportPattern(file.getExportOptions());
        if (fileExportPattern == null) {
            return true;
        }
        Predicate<String> patternPred = ProjectFilesUtils.isProjectFilePathSatisfiesPatterns(exportPattern, Collections.emptyList(), preserveHierarchy);
        return patternPred.test(Utils.noSepAtStart(Utils.normalizePath(fileExportPattern)));
    }

    public static SortedMap<String, Long> findObsoleteProjectDirectories(@NonNull Map<String, File> projectFiles, @NonNull Map<String, Long> directoryIds, @NonNull List<String> filesToUpload, @NonNull Map<String, File> obsoleteDeletedProjectFiles) {
        if (projectFiles == null) {
            throw new NullPointerException("projectFiles is marked non-null but is null");
        }
        if (directoryIds == null) {
            throw new NullPointerException("directoryIds is marked non-null but is null");
        }
        if (filesToUpload == null) {
            throw new NullPointerException("filesToUpload is marked non-null but is null");
        }
        if (obsoleteDeletedProjectFiles == null) {
            throw new NullPointerException("obsoleteDeletedProjectFiles is marked non-null but is null");
        }
        List upToDateDirs = filesToUpload.stream().map(Utils::getParentDirectory).collect(Collectors.toList());
        upToDateDirs.addAll(projectFiles.keySet().stream().filter(projectFile -> !obsoleteDeletedProjectFiles.containsKey(projectFile)).map(Utils::getParentDirectory).collect(Collectors.toSet()));
        for (int i = 0; i < upToDateDirs.size(); ++i) {
            String parentDir = Utils.getParentDirectory((String)upToDateDirs.get(i));
            if (upToDateDirs.contains(parentDir)) continue;
            upToDateDirs.add(parentDir);
        }
        List obsoleteDirPaths = obsoleteDeletedProjectFiles.keySet().stream().map(Utils::getParentDirectory).distinct().collect(Collectors.toList());
        for (int i = 0; i < obsoleteDirPaths.size(); ++i) {
            String parentDir = Utils.getParentDirectory((String)obsoleteDirPaths.get(i));
            if (obsoleteDirPaths.contains(parentDir)) continue;
            obsoleteDirPaths.add(parentDir);
        }
        obsoleteDirPaths.remove(Utils.PATH_SEPARATOR);
        TreeMap<String, Long> obsoleteDirs = new TreeMap<String, Long>(Collections.reverseOrder());
        for (String obsoleteDirPath : obsoleteDirPaths) {
            if (upToDateDirs.contains(obsoleteDirPath)) continue;
            obsoleteDirs.put(obsoleteDirPath, directoryIds.get(obsoleteDirPath));
        }
        return obsoleteDirs;
    }

    private static boolean isFileNotInList(List<String> filesToUpload, String filePath, boolean preserveHierarchy) {
        String filePathRegex = "^" + (preserveHierarchy ? "" : Utils.PRESERVE_HIERARCHY_REGEX_PART) + Utils.regexPath(filePath) + "$";
        return filesToUpload.stream().noneMatch(Pattern.compile(filePathRegex).asPredicate());
    }
}

