/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.functionality;

import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.properties.helper.FileHelper;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class SourcesUtils {
    public static Stream<File> getFiles(String basePath, String sourcePattern, List<String> ignorePattern, PlaceholderUtil placeholderUtil, LanguageMapping languageMapping) {
        if (basePath == null || sourcePattern == null || placeholderUtil == null) {
            throw new NullPointerException("null args in SourceUtils.getFiles");
        }
        FileHelper fileHelper = new FileHelper(basePath);
        String relativePath = StringUtils.removeStart(sourcePattern, basePath);
        List<File> sources = fileHelper.getFiles(relativePath);
        List<String> formattedIgnores = placeholderUtil.format(sources, ignorePattern, languageMapping);
        return fileHelper.filterOutIgnoredFiles(sources, formattedIgnores).stream().filter(File::isFile);
    }

    public static Stream<File> getFiles(String basePath, String sourcePattern, List<String> ignorePattern, PlaceholderUtil placeholderUtil) {
        return SourcesUtils.getFiles(basePath, sourcePattern, ignorePattern, placeholderUtil, null);
    }

    public static List<String> filterProjectFiles(List<String> filePaths, String sourcePattern, List<String> ignorePatterns, boolean preserveHierarchy, PlaceholderUtil placeholderUtil) {
        Predicate ignorePredicate;
        Predicate<String> sourcePredicate;
        filePaths = filePaths.stream().map(Utils.isWindows() != false ? Utils::toWindowsPath : Utils::toUnixPath).map(Utils::noSepAtStart).collect(Collectors.toList());
        sourcePattern = Utils.noSepAtStart(Utils.isWindows() != false ? Utils.toWindowsPath(sourcePattern) : Utils.toUnixPath(sourcePattern));
        List<Object> list = ignorePatterns != null ? ignorePatterns.stream().map(Utils.isWindows() != false ? Utils::toWindowsPath : Utils::toUnixPath).map(Utils::noSepAtStart).collect(Collectors.toList()) : (ignorePatterns = Collections.emptyList());
        if (preserveHierarchy) {
            sourcePredicate = Pattern.compile("^" + PlaceholderUtil.formatSourcePatternForRegex(sourcePattern) + "$").asPredicate();
            ignorePredicate = placeholderUtil.formatForRegex(ignorePatterns).stream().map(Pattern::compile).map(Pattern::asPredicate).map(Predicate::negate).reduce(s -> true, Predicate::and);
        } else {
            List patternPaths = Arrays.stream(sourcePattern.split(Pattern.quote(File.separator))).map(pathSplit -> Pattern.compile("^" + PlaceholderUtil.formatSourcePatternForRegex(pathSplit) + "$")).collect(Collectors.toList());
            Collections.reverse(patternPaths);
            sourcePredicate = filePath -> {
                List<String> filePathSplit = Arrays.asList(filePath.split("/+"));
                Collections.reverse(filePathSplit);
                int i = 0;
                while (i < filePathSplit.size()) {
                    if (i >= patternPaths.size()) {
                        return false;
                    }
                    if (((Pattern)patternPaths.get(i)).pattern().equals("^.+$")) {
                        return true;
                    }
                    if (!((Pattern)patternPaths.get(i)).matcher(filePathSplit.get(i)).matches()) {
                        return false;
                    }
                    ++i;
                }
                return true;
            };
            ignorePredicate = ignorePatterns.stream().map(ignorePattern -> {
                List<String> ignorePatternPaths = placeholderUtil.formatForRegex(Arrays.asList(ignorePattern.split(Pattern.quote(File.separator))));
                Collections.reverse(ignorePatternPaths);
                return ignorePatternPaths;
            }).map(path -> path.stream().map(Pattern::compile).collect(Collectors.toList())).map(ignorePatternPaths -> filePath -> {
                List<String> filePathSplit = Arrays.asList(filePath.split("[\\\\/]+"));
                Collections.reverse(filePathSplit);
                int i = 0;
                while (i <= filePathSplit.size()) {
                    if (i >= ignorePatternPaths.size()) {
                        return true;
                    }
                    if (((Pattern)ignorePatternPaths.get(i)).pattern().equals("^.+$")) {
                        return false;
                    }
                    if (i >= filePathSplit.size()) {
                        return true;
                    }
                    if (!((Pattern)ignorePatternPaths.get(i)).matcher(filePathSplit.get(i)).matches()) {
                        return true;
                    }
                    if (ignorePatternPaths.size() - 1 == i) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }).reduce(s -> true, Predicate::and);
        }
        return filePaths.stream().filter(sourcePredicate).filter(ignorePredicate).map(Utils::normalizePath).collect(Collectors.toList());
    }

    public static String replaceUnaryAsterisk(@NonNull String sourcePattern, @NonNull String projectFile) {
        if (sourcePattern == null) {
            throw new NullPointerException("sourcePattern is marked non-null but is null");
        }
        if (projectFile == null) {
            throw new NullPointerException("projectFile is marked non-null but is null");
        }
        String[] parts = Utils.splitPath(sourcePattern);
        String[] fileParts = Utils.splitPath(projectFile);
        for (int i = 1; i <= parts.length; ++i) {
            if (parts[parts.length - i].equals("**") || fileParts.length < i || !Pattern.matches(PlaceholderUtil.formatSourcePatternForRegex(parts[parts.length - i]), fileParts[fileParts.length - i])) continue;
            parts[parts.length - i] = fileParts[fileParts.length - i];
        }
        return Utils.joinPaths(parts);
    }

    public static boolean containsPattern(String sourcePattern) {
        if (sourcePattern == null) {
            return false;
        }
        return sourcePattern.contains("**") || sourcePattern.contains("*") || sourcePattern.contains("?") || sourcePattern.contains("[") && sourcePattern.contains("]") || sourcePattern.contains("\\") && Utils.isWindows() == false;
    }

    public static String getCommonPath(List<String> sources, String basePath) {
        String commonPrefix = StringUtils.getCommonPrefix(sources.toArray(new String[0]));
        String result = commonPrefix.substring(0, commonPrefix.lastIndexOf(Utils.PATH_SEPARATOR) + 1);
        result = StringUtils.removeStart(result, basePath);
        return result;
    }

    public static boolean isFileProperties(File source) {
        return FilenameUtils.isExtension(source.getName(), "properties");
    }

    public static boolean isFileJavaScript(File source) {
        return FilenameUtils.isExtension(source.getName(), "js");
    }
}

