/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import picocli.CommandLine;

public class ConfigurationFilesProperties {
    @CommandLine.Option(names={"-c", "--config"}, paramLabel="...")
    private File configFile;
    @CommandLine.Option(names={"--identity"}, paramLabel="...")
    private File identityFile;

    public File getConfigFile() {
        if (this.configFile == null) {
            this.configFile = this.getDefaultConfigFile();
        } else {
            if (!this.configFile.exists()) {
                throw new ExitCodeExceptionMapper.NotFoundException(BaseCli.RESOURCE_BUNDLE.getString("error.configuration_file_not_exist"));
            }
            if (this.configFile.isDirectory()) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.file.is_folder"));
            }
        }
        return this.configFile;
    }

    public File getIdentityFile() {
        if (this.identityFile == null) {
            this.identityFile = this.getDefaultIdentityFile();
        } else {
            if (!this.identityFile.exists()) {
                throw new ExitCodeExceptionMapper.NotFoundException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.identity_file_not_exist"), this.identityFile.getAbsolutePath()));
            }
            if (this.configFile.isDirectory()) {
                throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.file.is_folder"));
            }
        }
        return this.identityFile;
    }

    private File getDefaultConfigFile() {
        if (BaseCli.DEFAULT_CONFIGS == null || BaseCli.DEFAULT_CONFIGS.isEmpty()) {
            throw new ExitCodeExceptionMapper.ValidationException("Array of default values for config file is empty");
        }
        return BaseCli.DEFAULT_CONFIGS.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().map(Path::toFile).orElse(new File(BaseCli.DEFAULT_CONFIGS.get(0)));
    }

    private File getDefaultIdentityFile() {
        if (BaseCli.DEFAULT_IDENTITY_FILES == null || BaseCli.DEFAULT_IDENTITY_FILES.isEmpty()) {
            throw new ExitCodeExceptionMapper.ValidationException("Array of default values for config file is empty");
        }
        return BaseCli.DEFAULT_IDENTITY_FILES.stream().map(x$0 -> Paths.get(x$0, new String[0])).filter(x$0 -> Files.exists(x$0, new LinkOption[0])).findFirst().map(Path::toFile).orElse(null);
    }
}

