/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ClientDistribution;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandDistribution;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.client.distributions.model.ExportMode;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.util.Strings;
import picocli.CommandLine;

@CommandLine.Command(name="add", sortOptions=false)
class DistributionAddSubcommand
extends ActCommandDistribution {
    @CommandLine.Parameters(descriptionKey="crowdin.distribution.add.name")
    protected String name;
    @CommandLine.Option(names={"--export-mode"}, paramLabel="...", descriptionKey="crowdin.distribution.add.export-mode", defaultValue="default", order=-2)
    protected ExportMode exportMode;
    @CommandLine.Option(names={"--file"}, paramLabel="...", descriptionKey="crowdin.distribution.add.file", order=-2)
    protected List<String> files;
    @CommandLine.Option(names={"--bundle-id"}, paramLabel="...", descriptionKey="crowdin.distribution.add.bundle-id", order=-2)
    protected List<Integer> bundleIds;
    @CommandLine.Option(names={"-b", "--branch"}, paramLabel="...", descriptionKey="branch", order=-2)
    protected String branch;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;

    DistributionAddSubcommand() {
    }

    @Override
    protected NewAction<ProjectProperties, ClientDistribution> getAction(Actions actions) {
        return actions.distributionAdd(this.noProgress, this.plainView, this.name, this.exportMode, this.files, this.bundleIds, this.branch);
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        if (Strings.isEmpty(this.name)) {
            errors.add(RESOURCE_BUNDLE.getString("error.distribution.empty_name"));
        }
        if (this.exportMode == ExportMode.BUNDLE && this.bundleIds == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.distribution.empty_bundle_ids"));
        }
        if (this.exportMode == ExportMode.BUNDLE && this.files != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.distribution.incorrect_file_command_usage"));
        }
        if (this.exportMode == ExportMode.DEFAULT && this.bundleIds != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.distribution.incorrect_bundle_id_command_usage"));
        }
        return errors;
    }
}

