/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ClientGlossary;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandGlossary;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.BaseProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="upload", sortOptions=false)
class GlossaryUploadSubcommand
extends ActCommandGlossary {
    @CommandLine.Parameters(descriptionKey="crowdin.glossary.upload.file")
    private File file;
    @CommandLine.Option(names={"--id"}, paramLabel="...", descriptionKey="crowdin.glossary.upload.id", order=-2)
    private Long id;
    @CommandLine.Option(names={"--language"}, paramLabel="...", descriptionKey="crowdin.glossary.upload.language-id", order=-2)
    private String languageId;
    @CommandLine.Option(names={"--scheme"}, paramLabel="...", descriptionKey="crowdin.glossary.upload.scheme", order=-2)
    private Map<String, Integer> scheme;
    @CommandLine.Option(names={"--first-line-contains-header"}, descriptionKey="crowdin.glossary.upload.first-line-contains-header", order=-2)
    private Boolean firstLineContainsHeader;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;

    GlossaryUploadSubcommand() {
    }

    @Override
    protected NewAction<BaseProperties, ClientGlossary> getAction(Actions actions) {
        return actions.glossaryUpload(this.file, this.id, this.languageId, this.scheme, this.firstLineContainsHeader, this.plainView);
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        if (!this.file.exists()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(RESOURCE_BUNDLE.getString("error.file_not_found"), this.file));
        }
        if (this.file.isDirectory()) {
            errors.add(RESOURCE_BUNDLE.getString("error.file.is_folder"));
        }
        if (!this.equalsAny(FilenameUtils.getExtension(this.file.getName()), "tbx", "csv", "xls", "xlsx")) {
            errors.add(RESOURCE_BUNDLE.getString("error.glossary.wrong_format"));
        }
        if (!this.equalsAny(FilenameUtils.getExtension(this.file.getName()), "csv", "xls", "xlsx") && this.scheme != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.glossary.scheme_and_wrong_format"));
        } else if (this.equalsAny(FilenameUtils.getExtension(this.file.getName()), "csv", "xls", "xlsx") && this.scheme == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.glossary.scheme_is_required"));
        }
        if (!this.equalsAny(FilenameUtils.getExtension(this.file.getName()), "csv", "xls", "xlsx") && this.firstLineContainsHeader != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.glossary.first_line_contains_header_and_wrong_format"));
        }
        if (this.id == null && this.languageId == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.glossary.no_language_id"));
        }
        return errors;
    }

    private boolean equalsAny(String toCheck, String ... strings) {
        for (String string : strings) {
            if (!StringUtils.equalsIgnoreCase(toCheck, string)) continue;
            return true;
        }
        return false;
    }
}

