/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.commands.picocli.GenericActCommand;
import com.crowdin.cli.commands.picocli.HelpCommand;
import com.crowdin.cli.commands.picocli.RootCommand;
import com.crowdin.cli.properties.PropertiesBuilders;
import com.crowdin.cli.utils.OutputUtil;
import com.crowdin.cli.utils.Utils;
import java.util.stream.Stream;
import picocli.CommandLine;

public class PicocliRunner {
    private static PicocliRunner INSTANCE;
    private CommandLine commandLine;

    private PicocliRunner() {
        this.init();
    }

    public static PicocliRunner getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new PicocliRunner();
        }
        return INSTANCE;
    }

    public int execute(Actions actions, PropertiesBuilders propertiesBuilders, String ... args) {
        GenericActCommand.init(actions, propertiesBuilders);
        return this.commandLine.execute(args);
    }

    public boolean hasMatchedArg(String name) {
        CommandLine.ParseResult parseResult = this.commandLine.getParseResult();
        while (parseResult.hasSubcommand()) {
            parseResult = parseResult.subcommand();
        }
        return parseResult.hasMatchedOption(name);
    }

    public boolean noneMatchArgs(String ... args) {
        return Stream.of(args).noneMatch(this::hasMatchedArg);
    }

    private void init() {
        RootCommand rootCommand = new RootCommand();
        CommandLine.Help.ColorScheme colorScheme = PicocliRunner.buildColorScheme();
        CommandLine.IExecutionExceptionHandler executionExceptionHandler = PicocliRunner.buildExecutionExceptionHandler();
        this.commandLine = new CommandLine(rootCommand).setExecutionExceptionHandler(executionExceptionHandler).setColorScheme(colorScheme).setCaseInsensitiveEnumValuesAllowed(true).setExitCodeExceptionMapper(ExitCodeExceptionMapper::getExitCode).setExpandAtFiles(true);
        HelpCommand.setOptions(this.commandLine, System.out, colorScheme);
    }

    private static CommandLine.Help.ColorScheme buildColorScheme() {
        return new CommandLine.Help.ColorScheme.Builder().commands(CommandLine.Help.Ansi.Style.fg_green).options(CommandLine.Help.Ansi.Style.fg_green).parameters(CommandLine.Help.Ansi.Style.fg_green).errors(CommandLine.Help.Ansi.Style.fg_red).build();
    }

    private static CommandLine.IExecutionExceptionHandler buildExecutionExceptionHandler() {
        return (ex, cmd, pr) -> {
            boolean isDebug = pr.originalArgs().contains("--debug");
            OutputUtil.fancyErr((Throwable)ex, cmd.getErr(), isDebug);
            return ExitCodeExceptionMapper.getExitCode(ex);
        };
    }

    static class VersionProvider
    implements CommandLine.IVersionProvider {
        VersionProvider() {
        }

        @Override
        public String[] getVersion() {
            return new String[]{Utils.getAppVersion()};
        }
    }
}

