/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ProjectClient;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandProject;
import com.crowdin.cli.properties.ProjectProperties;
import com.crowdin.cli.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="list", sortOptions=false)
class StringListSubcommand
extends ActCommandProject {
    @CommandLine.Option(names={"--file"}, paramLabel="...", order=-2, descriptionKey="crowdin.string.list.file")
    protected String file;
    @CommandLine.Option(names={"--filter"}, paramLabel="...", order=-2, descriptionKey="crowdin.string.list.filter")
    protected String filter;
    @CommandLine.Option(names={"-b", "--branch"}, paramLabel="...", order=-2, descriptionKey="branch")
    protected String branchName;
    @CommandLine.Option(names={"--label"}, paramLabel="...", descriptionKey="crowdin.string.list.label", order=-2)
    protected List<String> labelNames;
    @CommandLine.Option(names={"--croql"}, paramLabel="...", order=-2, descriptionKey="crowdin.string.list.croql")
    protected String croql;
    @CommandLine.Option(names={"--directory"}, paramLabel="...", order=-2, descriptionKey="crowdin.string.list.directory-path")
    protected String directory;
    @CommandLine.Option(names={"--scope"}, paramLabel="...", order=-2, descriptionKey="crowdin.string.list.scope")
    protected String scope;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;

    StringListSubcommand() {
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        if (this.file != null) {
            this.file = StringUtils.removeStart(Utils.normalizePath(this.file), Utils.PATH_SEPARATOR);
        }
        if (Objects.nonNull(this.directory) && Objects.nonNull(this.file)) {
            errors.add(RESOURCE_BUNDLE.getString("error.status.only_one_allowed"));
        }
        return errors;
    }

    @Override
    protected NewAction<ProjectProperties, ProjectClient> getAction(Actions actions) {
        return actions.stringList(this.noProgress, this.isVerbose, this.file, this.filter, this.branchName, this.labelNames, this.croql, this.directory, this.scope, this.plainView);
    }
}

