/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.commands.picocli;

import com.crowdin.cli.client.ClientTm;
import com.crowdin.cli.commands.Actions;
import com.crowdin.cli.commands.NewAction;
import com.crowdin.cli.commands.picocli.ActCommandTm;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.BaseProperties;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import picocli.CommandLine;

@CommandLine.Command(name="upload", sortOptions=false)
class TmUploadSubcommand
extends ActCommandTm {
    @CommandLine.Parameters(descriptionKey="crowdin.tm.upload.file")
    private File file;
    @CommandLine.Option(names={"--id"}, paramLabel="...", descriptionKey="crowdin.tm.upload.id", order=-2)
    private Long id;
    @CommandLine.Option(names={"--language"}, paramLabel="...", descriptionKey="crowdin.tm.upload.language-id", order=-2)
    private String languageId;
    @CommandLine.Option(names={"--scheme"}, paramLabel="...", descriptionKey="crowdin.tm.upload.scheme", order=-2)
    private Map<String, Integer> scheme;
    @CommandLine.Option(names={"--first-line-contains-header"}, descriptionKey="crowdin.tm.upload.first-line-contains-header", order=-2)
    private Boolean firstLineContainsHeader;
    @CommandLine.Option(names={"--plain"}, descriptionKey="crowdin.list.usage.plain")
    protected boolean plainView;

    TmUploadSubcommand() {
    }

    @Override
    protected NewAction<BaseProperties, ClientTm> getAction(Actions actions) {
        return actions.tmUpload(this.file, this.id, this.languageId, this.scheme, this.firstLineContainsHeader, this.plainView);
    }

    @Override
    protected List<String> checkOptions() {
        ArrayList<String> errors = new ArrayList<String>();
        String extension = FilenameUtils.getExtension(this.file.getName());
        if (!this.file.exists()) {
            throw new ExitCodeExceptionMapper.NotFoundException(String.format(RESOURCE_BUNDLE.getString("error.file_not_found"), this.file));
        }
        if (this.file.isDirectory()) {
            errors.add(RESOURCE_BUNDLE.getString("error.file.is_folder"));
        }
        if (this.scheme == null && ("csv".equalsIgnoreCase(extension) || "xslx".equalsIgnoreCase(extension))) {
            errors.add(RESOURCE_BUNDLE.getString("error.tm.scheme_is_required"));
        }
        if (!this.equalsAny(FilenameUtils.getExtension(this.file.getName()), "tmx", "csv", "xls", "xlsx")) {
            errors.add(RESOURCE_BUNDLE.getString("error.tm.wrong_format"));
        }
        if (!this.equalsAny(FilenameUtils.getExtension(this.file.getName()), "csv", "xls", "xlsx") && this.firstLineContainsHeader != null) {
            errors.add(RESOURCE_BUNDLE.getString("error.tm.first_line_contains_header_and_wrong_format"));
        }
        if (this.id == null && this.languageId == null) {
            errors.add(RESOURCE_BUNDLE.getString("error.tm.no_language_id"));
        }
        return errors;
    }

    private boolean equalsAny(String toCheck, String ... strings) {
        for (String string : strings) {
            if (!StringUtils.equalsIgnoreCase(toCheck, string)) continue;
            return true;
        }
        return false;
    }
}

