/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.functionality.PropertiesBeanUtils;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.BaseParams;
import com.crowdin.cli.properties.BaseProperties;
import com.crowdin.cli.properties.PropertiesBuilder;
import com.crowdin.cli.properties.PropertiesConfigurator;
import java.util.Map;
import lombok.NonNull;

public class BasePropertiesBuilder
extends PropertiesBuilder<BaseProperties, BaseParams> {
    public BasePropertiesBuilder(Outputter outputter) {
        super(outputter);
    }

    @Override
    protected BaseProperties getEmptyInstance() {
        return new BaseProperties();
    }

    @Override
    protected void populateWithIdentityFileParams(BaseProperties props, @NonNull Map<String, Object> identityFileParams) {
        if (identityFileParams == null) {
            throw new NullPointerException("identityFileParams is marked non-null but is null");
        }
        BaseProperties.CONFIGURATOR.populateWithValues(props, identityFileParams);
    }

    @Override
    protected void populateWithConfigFileParams(BaseProperties props, @NonNull Map<String, Object> configFileParams) {
        if (configFileParams == null) {
            throw new NullPointerException("configFileParams is marked non-null but is null");
        }
        if (configFileParams.isEmpty()) {
            throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.empty_properties_file"));
        }
        BaseProperties.CONFIGURATOR.populateWithValues(props, configFileParams);
    }

    @Override
    protected PropertiesBuilder.Messages checkArgParams(@NonNull BaseParams params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        PropertiesBuilder.Messages messages = new PropertiesBuilder.Messages();
        if (params == null) {
            return messages;
        }
        if (params.getBaseUrlParam() != null && !PropertiesBeanUtils.isUrlValid(params.getBaseUrlParam())) {
            messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.wrong_base_url"));
        }
        if (params.getBasePathParam() != null) {
            if (!BasePropertiesBuilder.checkBasePathExists(params.getBasePathParam())) {
                messages.addError(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.config.base_path_not_exist"), params.getBasePathParam()));
            } else if (!BasePropertiesBuilder.checkBasePathIsDir(params.getBasePathParam())) {
                messages.addError(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.config.base_path_is_not_dir"), params.getBasePathParam()));
            }
        }
        return messages;
    }

    @Override
    protected void populateWithArgParams(BaseProperties props, @NonNull BaseParams params) {
        if (params == null) {
            throw new NullPointerException("params is marked non-null but is null");
        }
        if (params.getTokenParam() != null) {
            props.setApiToken(params.getTokenParam());
        }
        if (params.getBasePathParam() != null) {
            props.setBasePath(params.getBasePathParam());
        }
        if (params.getBaseUrlParam() != null) {
            props.setBaseUrl(params.getBaseUrlParam());
        }
    }

    @Override
    protected void populateWithEnvValues(BaseProperties props) {
        if (props == null) {
            return;
        }
        BaseProperties.CONFIGURATOR.populateWithEnvValues(props);
    }

    @Override
    protected void populateWithDefaultValues(BaseProperties props) {
        if (props == null) {
            return;
        }
        BaseProperties.CONFIGURATOR.populateWithDefaultValues(props);
    }

    @Override
    protected PropertiesBuilder.Messages checkProperties(BaseProperties props) {
        PropertiesBuilder.Messages messages = new PropertiesBuilder.Messages();
        if (props == null) {
            messages.addError(BaseCli.RESOURCE_BUNDLE.getString("error.config.property_bean_null"));
            return messages;
        }
        messages.populate(BaseProperties.CONFIGURATOR.checkProperties(props, PropertiesConfigurator.CheckType.STANDARD));
        return messages;
    }
}

