/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.functionality.SourcesUtils;
import com.crowdin.cli.properties.BeanConfigurator;
import com.crowdin.cli.properties.PropertiesBuilder;
import com.crowdin.cli.utils.PlaceholderUtil;
import com.crowdin.cli.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FileBean {
    static FileBeanConfigurator CONFIGURATOR = new FileBeanConfigurator();
    private String source;
    private String translation;
    private String context;
    private List<String> ignore;
    private Boolean multilingual;
    private String dest;
    private String type;
    private String updateOption;
    private Map<String, Map<String, String>> languagesMapping;
    private Boolean firstLineContainsHeader;
    private String scheme;
    private Boolean multilingualSpreadsheet;
    private Boolean translateAttributes;
    private Boolean translateContent;
    private List<String> translatableElements;
    private Boolean contentSegmentation;
    private Integer escapeQuotes;
    private Integer escapeSpecialCharacters;
    private String exportQuotes;
    private Map<String, String> translationReplace;
    private Boolean skipTranslatedOnly;
    private Boolean skipUntranslatedFiles;
    private Boolean exportApprovedOnly;
    private Boolean exportStringsThatPassedWorkflow;
    private List<String> labels;
    private List<String> excludedTargetLanguages;
    private String customSegmentation;
    private Boolean importTranslations;

    private static boolean checkDest(String dest, String source) {
        boolean destContainsPlaceholders = dest.contains("%file_name%") || dest.contains("%original_file_name%") || dest.contains("%original_path%") || dest.contains("%file_extension%") || dest.contains("**");
        boolean sourceContainsPlaceholders = PlaceholderUtil.containsFilePlaceholders(source) || SourcesUtils.containsPattern(source);
        return !sourceContainsPlaceholders || destContainsPlaceholders;
    }

    public String getSource() {
        return this.source;
    }

    public String getTranslation() {
        return this.translation;
    }

    public String getContext() {
        return this.context;
    }

    public List<String> getIgnore() {
        return this.ignore;
    }

    public Boolean getMultilingual() {
        return this.multilingual;
    }

    public String getDest() {
        return this.dest;
    }

    public String getType() {
        return this.type;
    }

    public String getUpdateOption() {
        return this.updateOption;
    }

    public Map<String, Map<String, String>> getLanguagesMapping() {
        return this.languagesMapping;
    }

    public Boolean getFirstLineContainsHeader() {
        return this.firstLineContainsHeader;
    }

    public String getScheme() {
        return this.scheme;
    }

    public Boolean getMultilingualSpreadsheet() {
        return this.multilingualSpreadsheet;
    }

    public Boolean getTranslateAttributes() {
        return this.translateAttributes;
    }

    public Boolean getTranslateContent() {
        return this.translateContent;
    }

    public List<String> getTranslatableElements() {
        return this.translatableElements;
    }

    public Boolean getContentSegmentation() {
        return this.contentSegmentation;
    }

    public Integer getEscapeQuotes() {
        return this.escapeQuotes;
    }

    public Integer getEscapeSpecialCharacters() {
        return this.escapeSpecialCharacters;
    }

    public String getExportQuotes() {
        return this.exportQuotes;
    }

    public Map<String, String> getTranslationReplace() {
        return this.translationReplace;
    }

    public Boolean getSkipTranslatedOnly() {
        return this.skipTranslatedOnly;
    }

    public Boolean getSkipUntranslatedFiles() {
        return this.skipUntranslatedFiles;
    }

    public Boolean getExportApprovedOnly() {
        return this.exportApprovedOnly;
    }

    public Boolean getExportStringsThatPassedWorkflow() {
        return this.exportStringsThatPassedWorkflow;
    }

    public List<String> getLabels() {
        return this.labels;
    }

    public List<String> getExcludedTargetLanguages() {
        return this.excludedTargetLanguages;
    }

    public String getCustomSegmentation() {
        return this.customSegmentation;
    }

    public Boolean getImportTranslations() {
        return this.importTranslations;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTranslation(String translation) {
        this.translation = translation;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setIgnore(List<String> ignore) {
        this.ignore = ignore;
    }

    public void setMultilingual(Boolean multilingual) {
        this.multilingual = multilingual;
    }

    public void setDest(String dest) {
        this.dest = dest;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setUpdateOption(String updateOption) {
        this.updateOption = updateOption;
    }

    public void setLanguagesMapping(Map<String, Map<String, String>> languagesMapping) {
        this.languagesMapping = languagesMapping;
    }

    public void setFirstLineContainsHeader(Boolean firstLineContainsHeader) {
        this.firstLineContainsHeader = firstLineContainsHeader;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setMultilingualSpreadsheet(Boolean multilingualSpreadsheet) {
        this.multilingualSpreadsheet = multilingualSpreadsheet;
    }

    public void setTranslateAttributes(Boolean translateAttributes) {
        this.translateAttributes = translateAttributes;
    }

    public void setTranslateContent(Boolean translateContent) {
        this.translateContent = translateContent;
    }

    public void setTranslatableElements(List<String> translatableElements) {
        this.translatableElements = translatableElements;
    }

    public void setContentSegmentation(Boolean contentSegmentation) {
        this.contentSegmentation = contentSegmentation;
    }

    public void setEscapeQuotes(Integer escapeQuotes) {
        this.escapeQuotes = escapeQuotes;
    }

    public void setEscapeSpecialCharacters(Integer escapeSpecialCharacters) {
        this.escapeSpecialCharacters = escapeSpecialCharacters;
    }

    public void setExportQuotes(String exportQuotes) {
        this.exportQuotes = exportQuotes;
    }

    public void setTranslationReplace(Map<String, String> translationReplace) {
        this.translationReplace = translationReplace;
    }

    public void setSkipTranslatedOnly(Boolean skipTranslatedOnly) {
        this.skipTranslatedOnly = skipTranslatedOnly;
    }

    public void setSkipUntranslatedFiles(Boolean skipUntranslatedFiles) {
        this.skipUntranslatedFiles = skipUntranslatedFiles;
    }

    public void setExportApprovedOnly(Boolean exportApprovedOnly) {
        this.exportApprovedOnly = exportApprovedOnly;
    }

    public void setExportStringsThatPassedWorkflow(Boolean exportStringsThatPassedWorkflow) {
        this.exportStringsThatPassedWorkflow = exportStringsThatPassedWorkflow;
    }

    public void setLabels(List<String> labels) {
        this.labels = labels;
    }

    public void setExcludedTargetLanguages(List<String> excludedTargetLanguages) {
        this.excludedTargetLanguages = excludedTargetLanguages;
    }

    public void setCustomSegmentation(String customSegmentation) {
        this.customSegmentation = customSegmentation;
    }

    public void setImportTranslations(Boolean importTranslations) {
        this.importTranslations = importTranslations;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FileBean)) {
            return false;
        }
        FileBean other = (FileBean)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$multilingual = this.getMultilingual();
        Boolean other$multilingual = other.getMultilingual();
        if (this$multilingual == null ? other$multilingual != null : !((Object)this$multilingual).equals(other$multilingual)) {
            return false;
        }
        Boolean this$firstLineContainsHeader = this.getFirstLineContainsHeader();
        Boolean other$firstLineContainsHeader = other.getFirstLineContainsHeader();
        if (this$firstLineContainsHeader == null ? other$firstLineContainsHeader != null : !((Object)this$firstLineContainsHeader).equals(other$firstLineContainsHeader)) {
            return false;
        }
        Boolean this$multilingualSpreadsheet = this.getMultilingualSpreadsheet();
        Boolean other$multilingualSpreadsheet = other.getMultilingualSpreadsheet();
        if (this$multilingualSpreadsheet == null ? other$multilingualSpreadsheet != null : !((Object)this$multilingualSpreadsheet).equals(other$multilingualSpreadsheet)) {
            return false;
        }
        Boolean this$translateAttributes = this.getTranslateAttributes();
        Boolean other$translateAttributes = other.getTranslateAttributes();
        if (this$translateAttributes == null ? other$translateAttributes != null : !((Object)this$translateAttributes).equals(other$translateAttributes)) {
            return false;
        }
        Boolean this$translateContent = this.getTranslateContent();
        Boolean other$translateContent = other.getTranslateContent();
        if (this$translateContent == null ? other$translateContent != null : !((Object)this$translateContent).equals(other$translateContent)) {
            return false;
        }
        Boolean this$contentSegmentation = this.getContentSegmentation();
        Boolean other$contentSegmentation = other.getContentSegmentation();
        if (this$contentSegmentation == null ? other$contentSegmentation != null : !((Object)this$contentSegmentation).equals(other$contentSegmentation)) {
            return false;
        }
        Integer this$escapeQuotes = this.getEscapeQuotes();
        Integer other$escapeQuotes = other.getEscapeQuotes();
        if (this$escapeQuotes == null ? other$escapeQuotes != null : !((Object)this$escapeQuotes).equals(other$escapeQuotes)) {
            return false;
        }
        Integer this$escapeSpecialCharacters = this.getEscapeSpecialCharacters();
        Integer other$escapeSpecialCharacters = other.getEscapeSpecialCharacters();
        if (this$escapeSpecialCharacters == null ? other$escapeSpecialCharacters != null : !((Object)this$escapeSpecialCharacters).equals(other$escapeSpecialCharacters)) {
            return false;
        }
        Boolean this$skipTranslatedOnly = this.getSkipTranslatedOnly();
        Boolean other$skipTranslatedOnly = other.getSkipTranslatedOnly();
        if (this$skipTranslatedOnly == null ? other$skipTranslatedOnly != null : !((Object)this$skipTranslatedOnly).equals(other$skipTranslatedOnly)) {
            return false;
        }
        Boolean this$skipUntranslatedFiles = this.getSkipUntranslatedFiles();
        Boolean other$skipUntranslatedFiles = other.getSkipUntranslatedFiles();
        if (this$skipUntranslatedFiles == null ? other$skipUntranslatedFiles != null : !((Object)this$skipUntranslatedFiles).equals(other$skipUntranslatedFiles)) {
            return false;
        }
        Boolean this$exportApprovedOnly = this.getExportApprovedOnly();
        Boolean other$exportApprovedOnly = other.getExportApprovedOnly();
        if (this$exportApprovedOnly == null ? other$exportApprovedOnly != null : !((Object)this$exportApprovedOnly).equals(other$exportApprovedOnly)) {
            return false;
        }
        Boolean this$exportStringsThatPassedWorkflow = this.getExportStringsThatPassedWorkflow();
        Boolean other$exportStringsThatPassedWorkflow = other.getExportStringsThatPassedWorkflow();
        if (this$exportStringsThatPassedWorkflow == null ? other$exportStringsThatPassedWorkflow != null : !((Object)this$exportStringsThatPassedWorkflow).equals(other$exportStringsThatPassedWorkflow)) {
            return false;
        }
        Boolean this$importTranslations = this.getImportTranslations();
        Boolean other$importTranslations = other.getImportTranslations();
        if (this$importTranslations == null ? other$importTranslations != null : !((Object)this$importTranslations).equals(other$importTranslations)) {
            return false;
        }
        String this$source = this.getSource();
        String other$source = other.getSource();
        if (this$source == null ? other$source != null : !this$source.equals(other$source)) {
            return false;
        }
        String this$translation = this.getTranslation();
        String other$translation = other.getTranslation();
        if (this$translation == null ? other$translation != null : !this$translation.equals(other$translation)) {
            return false;
        }
        String this$context = this.getContext();
        String other$context = other.getContext();
        if (this$context == null ? other$context != null : !this$context.equals(other$context)) {
            return false;
        }
        List<String> this$ignore = this.getIgnore();
        List<String> other$ignore = other.getIgnore();
        if (this$ignore == null ? other$ignore != null : !((Object)this$ignore).equals(other$ignore)) {
            return false;
        }
        String this$dest = this.getDest();
        String other$dest = other.getDest();
        if (this$dest == null ? other$dest != null : !this$dest.equals(other$dest)) {
            return false;
        }
        String this$type = this.getType();
        String other$type = other.getType();
        if (this$type == null ? other$type != null : !this$type.equals(other$type)) {
            return false;
        }
        String this$updateOption = this.getUpdateOption();
        String other$updateOption = other.getUpdateOption();
        if (this$updateOption == null ? other$updateOption != null : !this$updateOption.equals(other$updateOption)) {
            return false;
        }
        Map<String, Map<String, String>> this$languagesMapping = this.getLanguagesMapping();
        Map<String, Map<String, String>> other$languagesMapping = other.getLanguagesMapping();
        if (this$languagesMapping == null ? other$languagesMapping != null : !((Object)this$languagesMapping).equals(other$languagesMapping)) {
            return false;
        }
        String this$scheme = this.getScheme();
        String other$scheme = other.getScheme();
        if (this$scheme == null ? other$scheme != null : !this$scheme.equals(other$scheme)) {
            return false;
        }
        List<String> this$translatableElements = this.getTranslatableElements();
        List<String> other$translatableElements = other.getTranslatableElements();
        if (this$translatableElements == null ? other$translatableElements != null : !((Object)this$translatableElements).equals(other$translatableElements)) {
            return false;
        }
        String this$exportQuotes = this.getExportQuotes();
        String other$exportQuotes = other.getExportQuotes();
        if (this$exportQuotes == null ? other$exportQuotes != null : !this$exportQuotes.equals(other$exportQuotes)) {
            return false;
        }
        Map<String, String> this$translationReplace = this.getTranslationReplace();
        Map<String, String> other$translationReplace = other.getTranslationReplace();
        if (this$translationReplace == null ? other$translationReplace != null : !((Object)this$translationReplace).equals(other$translationReplace)) {
            return false;
        }
        List<String> this$labels = this.getLabels();
        List<String> other$labels = other.getLabels();
        if (this$labels == null ? other$labels != null : !((Object)this$labels).equals(other$labels)) {
            return false;
        }
        List<String> this$excludedTargetLanguages = this.getExcludedTargetLanguages();
        List<String> other$excludedTargetLanguages = other.getExcludedTargetLanguages();
        if (this$excludedTargetLanguages == null ? other$excludedTargetLanguages != null : !((Object)this$excludedTargetLanguages).equals(other$excludedTargetLanguages)) {
            return false;
        }
        String this$customSegmentation = this.getCustomSegmentation();
        String other$customSegmentation = other.getCustomSegmentation();
        return !(this$customSegmentation == null ? other$customSegmentation != null : !this$customSegmentation.equals(other$customSegmentation));
    }

    protected boolean canEqual(Object other) {
        return other instanceof FileBean;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $multilingual = this.getMultilingual();
        result = result * 59 + ($multilingual == null ? 43 : ((Object)$multilingual).hashCode());
        Boolean $firstLineContainsHeader = this.getFirstLineContainsHeader();
        result = result * 59 + ($firstLineContainsHeader == null ? 43 : ((Object)$firstLineContainsHeader).hashCode());
        Boolean $multilingualSpreadsheet = this.getMultilingualSpreadsheet();
        result = result * 59 + ($multilingualSpreadsheet == null ? 43 : ((Object)$multilingualSpreadsheet).hashCode());
        Boolean $translateAttributes = this.getTranslateAttributes();
        result = result * 59 + ($translateAttributes == null ? 43 : ((Object)$translateAttributes).hashCode());
        Boolean $translateContent = this.getTranslateContent();
        result = result * 59 + ($translateContent == null ? 43 : ((Object)$translateContent).hashCode());
        Boolean $contentSegmentation = this.getContentSegmentation();
        result = result * 59 + ($contentSegmentation == null ? 43 : ((Object)$contentSegmentation).hashCode());
        Integer $escapeQuotes = this.getEscapeQuotes();
        result = result * 59 + ($escapeQuotes == null ? 43 : ((Object)$escapeQuotes).hashCode());
        Integer $escapeSpecialCharacters = this.getEscapeSpecialCharacters();
        result = result * 59 + ($escapeSpecialCharacters == null ? 43 : ((Object)$escapeSpecialCharacters).hashCode());
        Boolean $skipTranslatedOnly = this.getSkipTranslatedOnly();
        result = result * 59 + ($skipTranslatedOnly == null ? 43 : ((Object)$skipTranslatedOnly).hashCode());
        Boolean $skipUntranslatedFiles = this.getSkipUntranslatedFiles();
        result = result * 59 + ($skipUntranslatedFiles == null ? 43 : ((Object)$skipUntranslatedFiles).hashCode());
        Boolean $exportApprovedOnly = this.getExportApprovedOnly();
        result = result * 59 + ($exportApprovedOnly == null ? 43 : ((Object)$exportApprovedOnly).hashCode());
        Boolean $exportStringsThatPassedWorkflow = this.getExportStringsThatPassedWorkflow();
        result = result * 59 + ($exportStringsThatPassedWorkflow == null ? 43 : ((Object)$exportStringsThatPassedWorkflow).hashCode());
        Boolean $importTranslations = this.getImportTranslations();
        result = result * 59 + ($importTranslations == null ? 43 : ((Object)$importTranslations).hashCode());
        String $source = this.getSource();
        result = result * 59 + ($source == null ? 43 : $source.hashCode());
        String $translation = this.getTranslation();
        result = result * 59 + ($translation == null ? 43 : $translation.hashCode());
        String $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        List<String> $ignore = this.getIgnore();
        result = result * 59 + ($ignore == null ? 43 : ((Object)$ignore).hashCode());
        String $dest = this.getDest();
        result = result * 59 + ($dest == null ? 43 : $dest.hashCode());
        String $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        String $updateOption = this.getUpdateOption();
        result = result * 59 + ($updateOption == null ? 43 : $updateOption.hashCode());
        Map<String, Map<String, String>> $languagesMapping = this.getLanguagesMapping();
        result = result * 59 + ($languagesMapping == null ? 43 : ((Object)$languagesMapping).hashCode());
        String $scheme = this.getScheme();
        result = result * 59 + ($scheme == null ? 43 : $scheme.hashCode());
        List<String> $translatableElements = this.getTranslatableElements();
        result = result * 59 + ($translatableElements == null ? 43 : ((Object)$translatableElements).hashCode());
        String $exportQuotes = this.getExportQuotes();
        result = result * 59 + ($exportQuotes == null ? 43 : $exportQuotes.hashCode());
        Map<String, String> $translationReplace = this.getTranslationReplace();
        result = result * 59 + ($translationReplace == null ? 43 : ((Object)$translationReplace).hashCode());
        List<String> $labels = this.getLabels();
        result = result * 59 + ($labels == null ? 43 : ((Object)$labels).hashCode());
        List<String> $excludedTargetLanguages = this.getExcludedTargetLanguages();
        result = result * 59 + ($excludedTargetLanguages == null ? 43 : ((Object)$excludedTargetLanguages).hashCode());
        String $customSegmentation = this.getCustomSegmentation();
        result = result * 59 + ($customSegmentation == null ? 43 : $customSegmentation.hashCode());
        return result;
    }

    public String toString() {
        return "FileBean(source=" + this.getSource() + ", translation=" + this.getTranslation() + ", context=" + this.getContext() + ", ignore=" + String.valueOf(this.getIgnore()) + ", multilingual=" + this.getMultilingual() + ", dest=" + this.getDest() + ", type=" + this.getType() + ", updateOption=" + this.getUpdateOption() + ", languagesMapping=" + String.valueOf(this.getLanguagesMapping()) + ", firstLineContainsHeader=" + this.getFirstLineContainsHeader() + ", scheme=" + this.getScheme() + ", multilingualSpreadsheet=" + this.getMultilingualSpreadsheet() + ", translateAttributes=" + this.getTranslateAttributes() + ", translateContent=" + this.getTranslateContent() + ", translatableElements=" + String.valueOf(this.getTranslatableElements()) + ", contentSegmentation=" + this.getContentSegmentation() + ", escapeQuotes=" + this.getEscapeQuotes() + ", escapeSpecialCharacters=" + this.getEscapeSpecialCharacters() + ", exportQuotes=" + this.getExportQuotes() + ", translationReplace=" + String.valueOf(this.getTranslationReplace()) + ", skipTranslatedOnly=" + this.getSkipTranslatedOnly() + ", skipUntranslatedFiles=" + this.getSkipUntranslatedFiles() + ", exportApprovedOnly=" + this.getExportApprovedOnly() + ", exportStringsThatPassedWorkflow=" + this.getExportStringsThatPassedWorkflow() + ", labels=" + String.valueOf(this.getLabels()) + ", excludedTargetLanguages=" + String.valueOf(this.getExcludedTargetLanguages()) + ", customSegmentation=" + this.getCustomSegmentation() + ", importTranslations=" + this.getImportTranslations() + ")";
    }

    static class FileBeanConfigurator
    implements BeanConfigurator<FileBean> {
        private FileBeanConfigurator() {
        }

        @Override
        public FileBean buildFromMap(Map<String, Object> map) {
            FileBean fileBean = new FileBean();
            PropertiesBuilder.setPropertyIfExists(fileBean::setSource, map, "source", String.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setDest, map, "dest", String.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setType, map, "type", String.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setTranslation, map, "translation", String.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setContext, map, "context", String.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setUpdateOption, map, "update_option", String.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setScheme, map, "scheme", String.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setIgnore, map, "ignore", List.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setTranslatableElements, map, "translatable_elements", List.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setLanguagesMapping, map, "languages_mapping", Map.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setTranslationReplace, map, "translation_replace", Map.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setEscapeQuotes, map, "escape_quotes", Integer.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setEscapeSpecialCharacters, map, "escape_special_characters", Integer.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setExportQuotes, map, "export_quotes", String.class);
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setFirstLineContainsHeader, map, "first_line_contains_header");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setTranslateAttributes, map, "translate_attributes");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setTranslateContent, map, "translate_content");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setContentSegmentation, map, "content_segmentation");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setMultilingual, map, "multilingual");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setMultilingualSpreadsheet, map, "multilingual_spreadsheet");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setSkipTranslatedOnly, map, "skip_untranslated_strings");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setSkipUntranslatedFiles, map, "skip_untranslated_files");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setExportApprovedOnly, map, "export_only_approved");
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setExportStringsThatPassedWorkflow, map, "export_strings_that_passed_workflow");
            PropertiesBuilder.setPropertyIfExists(fileBean::setLabels, map, "labels", List.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setExcludedTargetLanguages, map, "excluded_target_languages", List.class);
            PropertiesBuilder.setPropertyIfExists(fileBean::setCustomSegmentation, map, "custom_segmentation", String.class);
            PropertiesBuilder.setBooleanPropertyIfExists(fileBean::setImportTranslations, map, "import_translations");
            return fileBean;
        }

        @Override
        public void populateWithDefaultValues(FileBean bean) {
            if (bean.getSource() != null) {
                bean.setSource(Utils.normalizePath(bean.getSource()));
            }
            if (bean.getTranslation() != null) {
                bean.setTranslation(Utils.normalizePath(bean.getTranslation()));
                if (!PlaceholderUtil.containsLangPlaceholders(bean.getTranslation()) && (bean.getScheme() != null || bean.getMultilingual() != null && bean.getMultilingual().booleanValue())) {
                    bean.setTranslation(Utils.noSepAtStart(bean.getTranslation()));
                } else {
                    bean.setTranslation(Utils.sepAtStart(bean.getTranslation()));
                }
            }
            if (bean.getIgnore() != null && !bean.getIgnore().isEmpty()) {
                ArrayList<String> ignores = new ArrayList<String>();
                for (String ignore : bean.getIgnore()) {
                    ignores.add(ignore.replaceAll("[/\\\\]+", Utils.PATH_SEPARATOR_REGEX));
                }
                bean.setIgnore(ignores);
            }
            if (bean.getMultilingual() == null) {
                bean.setMultilingual(Boolean.FALSE);
            }
            if (StringUtils.isNotEmpty(bean.getDest())) {
                bean.setDest(bean.getDest().replaceAll("[/\\\\]+", Utils.PATH_SEPARATOR_REGEX));
            }
            if (bean.getTranslateAttributes() == null) {
                bean.setTranslateAttributes(Boolean.FALSE);
            }
            bean.setTranslateContent(bean.getTranslateContent() != null ? bean.getTranslateContent() : Boolean.TRUE);
            bean.setContentSegmentation(bean.getContentSegmentation());
            if (bean.getEscapeQuotes() == null) {
                bean.setEscapeQuotes(3);
            }
            if (bean.getFirstLineContainsHeader() == null) {
                bean.setFirstLineContainsHeader(Boolean.FALSE);
            }
            if (bean.getCustomSegmentation() != null) {
                bean.setCustomSegmentation(Utils.normalizePath(bean.getCustomSegmentation()));
            }
            if (bean.getImportTranslations() == null) {
                bean.setImportTranslations(Boolean.FALSE);
            }
        }

        @Override
        public List<String> checkProperties(FileBean bean) {
            String exportQuotes;
            Integer escSpecialCharacters;
            Integer escQuotes;
            ArrayList<String> errors = new ArrayList<String>();
            if (StringUtils.isEmpty(bean.getSource())) {
                errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.empty_source_section"));
            }
            if (StringUtils.isEmpty(bean.getTranslation())) {
                errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.empty_translation_section"));
            } else {
                if (!PropertiesBuilder.checkForDoubleAsterisks(bean.getSource(), bean.getTranslation())) {
                    errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.double_asterisk"));
                }
                if (!(PlaceholderUtil.containsLangPlaceholders(bean.getTranslation()) || bean.getScheme() != null || bean.getMultilingual() != null && bean.getMultilingual().booleanValue())) {
                    errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.translation_has_no_language_placeholders"));
                }
                if (PropertiesBuilder.hasRelativePaths(bean.getTranslation())) {
                    errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.translation_contains_relative_paths"));
                }
            }
            String updateOption = bean.getUpdateOption();
            if (updateOption != null && !updateOption.equals("update_as_unapproved") && !updateOption.equals("update_without_changes")) {
                errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.update_option"));
            }
            if ((escQuotes = bean.getEscapeQuotes()) != null && (escQuotes < 0 || escQuotes > 3)) {
                errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.escape_quotes"));
            }
            if ((escSpecialCharacters = bean.getEscapeSpecialCharacters()) != null && (escSpecialCharacters < 0 || escSpecialCharacters > 1)) {
                errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.escape_special_characters"));
            }
            if ((exportQuotes = bean.getExportQuotes()) != null && !exportQuotes.equals("single") && !exportQuotes.equals("double")) {
                errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.config.export_quotes"));
            }
            if (StringUtils.isNotEmpty(bean.getDest()) && !FileBean.checkDest(bean.getDest(), bean.getSource())) {
                errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.dest_and_pattern_in_source"));
            }
            if (bean.getSkipTranslatedOnly() != null && bean.getSkipUntranslatedFiles() != null && bean.getSkipTranslatedOnly().booleanValue() && bean.getSkipUntranslatedFiles().booleanValue()) {
                errors.add(BaseCli.RESOURCE_BUNDLE.getString("error.skip_untranslated_both_strings_and_files"));
            }
            return errors;
        }
    }
}

