/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.properties.Params;
import com.crowdin.cli.properties.Properties;
import com.crowdin.cli.utils.console.ExecutionStatus;
import io.github.cdimascio.dotenv.Dotenv;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public abstract class PropertiesBuilder<T extends Properties, P extends Params> {
    private static Dotenv dotenv;
    public static final String PROJECT_ID = "project_id";
    public static final String PROJECT_ID_ENV = "project_id_env";
    public static final String CROWDIN_PROJECT_ID = "CROWDIN_PROJECT_ID";
    public static final String API_TOKEN = "api_token";
    public static final String API_TOKEN_ENV = "api_token_env";
    public static final String CROWDIN_PERSONAL_TOKEN = "CROWDIN_PERSONAL_TOKEN";
    public static final String BASE_PATH = "base_path";
    public static final String BASE_PATH_ENV = "base_path_env";
    public static final String CROWDIN_BASE_PATH = "CROWDIN_BASE_PATH";
    public static final String BASE_URL = "base_url";
    public static final String BASE_URL_ENV = "base_url_env";
    public static final String CROWDIN_BASE_URL = "CROWDIN_BASE_URL";
    public static final String PRESERVE_HIERARCHY = "preserve_hierarchy";
    public static final String FILES = "files";
    public static final String SOURCE = "source";
    public static final String IGNORE = "ignore";
    public static final String MULTILINGUAL = "multilingual";
    public static final String DEST = "dest";
    public static final String TYPE = "type";
    public static final String TRANSLATION = "translation";
    public static final String CONTEXT = "context";
    public static final String UPDATE_OPTION = "update_option";
    public static final String LANGUAGES_MAPPING = "languages_mapping";
    public static final String FIRST_LINE_CONTAINS_HEADER = "first_line_contains_header";
    public static final String TRANSLATE_ATTRIBUTES = "translate_attributes";
    public static final String TRANSLATE_CONTENT = "translate_content";
    public static final String TRANSLATABLE_ELEMENTS = "translatable_elements";
    public static final String CONTENT_SEGMENTATION = "content_segmentation";
    public static final String ESCAPE_QUOTES = "escape_quotes";
    public static final String ESCAPE_SPECIAL_CHARACTERS = "escape_special_characters";
    public static final String EXPORT_QUOTES = "export_quotes";
    public static final String MULTILINGUAL_SPREADSHEET = "multilingual_spreadsheet";
    public static final String SCHEME = "scheme";
    public static final String TRANSLATION_REPLACE = "translation_replace";
    public static final String LABELS = "labels";
    public static final String PSEUDO_LOCALIZATION = "pseudo_localization";
    public static final String LENGTH_CORRECTION = "length_correction";
    public static final String PREFIX = "prefix";
    public static final String SUFFIX = "suffix";
    public static final String CHARACTER_TRANSFORMATION = "character_transformation";
    public static final String SKIP_UNTRANSLATED_STRINGS = "skip_untranslated_strings";
    public static final String SKIP_UNTRANSLATED_FILES = "skip_untranslated_files";
    public static final String EXPORT_APPROVED_ONLY = "export_only_approved";
    public static final String EXPORT_STRINGS_THAT_PASSED_WORKFLOW = "export_strings_that_passed_workflow";
    public static final String EXCLUDED_TARGET_LANGUAGES = "excluded_target_languages";
    public static final String CUSTOM_SEGMENTATION = "custom_segmentation";
    public static final String SETTINGS = "settings";
    public static final String IGNORE_HIDDEN_FILES = "ignore_hidden_files";
    public static final String CONFIG_FILE_PATH = "config_file_path";
    public static final String IMPORT_TRANSLATIONS = "import_translations";
    private Outputter out;
    private Map<String, Object> configFileParams;
    private Map<String, Object> identityFileParams;
    private P params;

    public PropertiesBuilder(Outputter out) {
        this.out = out;
    }

    public PropertiesBuilder<T, P> addConfigParams(Map<String, Object> configFileParams) {
        if (configFileParams != null) {
            this.configFileParams = configFileParams;
        }
        return this;
    }

    public PropertiesBuilder<T, P> addIdentityParams(Map<String, Object> identityFileParams) {
        if (identityFileParams != null) {
            this.identityFileParams = identityFileParams;
        }
        return this;
    }

    public PropertiesBuilder<T, P> addParams(P params) {
        if (params != null) {
            this.params = params;
        }
        return this;
    }

    public T build() {
        T props = this.getEmptyInstance();
        if (this.configFileParams != null) {
            this.populateWithConfigFileParams(props, this.configFileParams);
        }
        if (this.identityFileParams != null) {
            this.populateWithIdentityFileParams(props, this.identityFileParams);
        }
        if (this.params != null) {
            this.throwErrorIfNeeded(this.checkArgParams(this.params), BaseCli.RESOURCE_BUNDLE.getString("error.params_are_invalid"));
            this.populateWithArgParams(props, this.params);
        }
        this.populateWithEnvValues(props);
        this.populateWithDefaultValues(props);
        String errorTitle = this.configFileParams == null && this.identityFileParams == null ? BaseCli.RESOURCE_BUNDLE.getString("error.configuration_is_invalid") : BaseCli.RESOURCE_BUNDLE.getString("error.configuration_file_is_invalid");
        this.throwErrorIfNeeded(this.checkProperties(props), errorTitle);
        return props;
    }

    private void throwErrorIfNeeded(Messages messages, String text) {
        messages.getWarnings().stream().map(ExecutionStatus.WARNING::withIcon).forEach(this.out::println);
        if (!messages.getErrors().isEmpty()) {
            String errorsInOne = messages.getErrors().stream().map(error -> String.format(BaseCli.RESOURCE_BUNDLE.getString("message.item_list"), error)).collect(Collectors.joining("\n"));
            throw new ExitCodeExceptionMapper.ValidationException(text + "\n" + errorsInOne);
        }
    }

    protected abstract T getEmptyInstance();

    protected abstract void populateWithIdentityFileParams(T var1, @NonNull Map<String, Object> var2);

    protected abstract void populateWithConfigFileParams(T var1, @NonNull Map<String, Object> var2);

    protected abstract Messages checkArgParams(@NonNull P var1);

    protected abstract void populateWithArgParams(T var1, @NonNull P var2);

    protected abstract void populateWithEnvValues(T var1);

    protected abstract void populateWithDefaultValues(T var1);

    protected abstract Messages checkProperties(T var1);

    static List<Map<String, Object>> getListOfMaps(Map<String, Object> map, String key) {
        List<Map<String, Object>> list = PropertiesBuilder.checkProperty(map, key, List.class, Collections.emptyList());
        for (Object t : list) {
            if (t instanceof Map) continue;
            throw new ExitCodeExceptionMapper.ValidationException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.cast_param_list_type"), key, PropertiesBuilder.typeName(t.getClass()), PropertiesBuilder.typeName(Map.class)));
        }
        List<Map<String, Object>> returnType = list;
        return returnType;
    }

    static Map<String, Object> getMap(Map<String, Object> map, String key) {
        Map<String, Object> returnType = PropertiesBuilder.checkProperty(map, key, Map.class, Collections.emptyMap());
        return returnType;
    }

    static void setEnvOrPropertyIfExists(Consumer<String> setter, Map<String, Object> properties, String envKey, String key) {
        String param;
        String string = properties.containsKey(envKey) ? PropertiesBuilder.getDotenv().get(properties.get(envKey).toString()) : (properties.containsKey(key) ? (properties.get(key) != null ? properties.get(key).toString() : null) : (param = null));
        if (param != null) {
            setter.accept(param);
        }
    }

    static void setEnvIfExists(Consumer<String> setter, String envKey) {
        String param = System.getenv(envKey);
        if (param != null) {
            setter.accept(param);
        }
    }

    private static Dotenv getDotenv() {
        if (dotenv == null) {
            try {
                dotenv = Dotenv.configure().ignoreIfMissing().ignoreIfMalformed().load();
            }
            catch (IllegalStateException e) {
                if (e.getMessage() != null && e.getMessage().contains("Duplicate key")) {
                    throw new ExitCodeExceptionMapper.ValidationException(BaseCli.RESOURCE_BUNDLE.getString("error.duplicate_environment_variable"), e);
                }
                throw e;
            }
        }
        return dotenv;
    }

    static void setBooleanPropertyIfExists(Consumer<Boolean> setter, Map<String, Object> properties, String key) {
        Boolean param;
        Boolean bl = properties.containsKey(key) ? (properties.get(key).toString().equals("1") ? Boolean.TRUE : Boolean.valueOf(properties.get(key).toString())) : (param = null);
        if (param != null) {
            setter.accept(param);
        }
    }

    static <T> void setPropertyIfExists(Consumer<T> setter, Map<String, Object> properties, String key, Class<T> clazz) {
        Object param = PropertiesBuilder.checkProperty(properties, key, clazz, null);
        if (param != null) {
            setter.accept(param);
        }
    }

    private static <T> T checkProperty(Map<String, Object> properties, String key, Class<T> clazz, T defaultValue) {
        try {
            Object param = properties.getOrDefault(key, defaultValue);
            if (param != null && !clazz.isAssignableFrom(param.getClass())) {
                String desiredType = PropertiesBuilder.typeName(clazz);
                String presentType = PropertiesBuilder.typeName(param.getClass());
                throw new ExitCodeExceptionMapper.ValidationException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.cast_param_type"), key, presentType, desiredType));
            }
            Object paramWithType = param;
            return (T)paramWithType;
        }
        catch (ClassCastException e) {
            throw new ExitCodeExceptionMapper.ValidationException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.cast_param"), key), e);
        }
    }

    private static String typeName(Class<?> clazz) {
        if (Integer.class.isAssignableFrom(clazz)) {
            return "Integer";
        }
        if (Double.class.isAssignableFrom(clazz)) {
            return "Double";
        }
        if (Boolean.class.isAssignableFrom(clazz)) {
            return "Boolean";
        }
        if (String.class.isAssignableFrom(clazz)) {
            return "String";
        }
        if (List.class.isAssignableFrom(clazz)) {
            return "List";
        }
        return "Map";
    }

    static void setEnumPropertyIfExists(Consumer<String> setter, Map<String, Object> properties, String key, String acceptableValuesEnum) {
        try {
            String param = (String)properties.get(key);
            if (param != null) {
                setter.accept(param);
            }
        }
        catch (ClassCastException e) {
            throw new ExitCodeExceptionMapper.ValidationException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.config.enum_class_exception"), key, acceptableValuesEnum));
        }
        catch (IllegalArgumentException e) {
            throw new ExitCodeExceptionMapper.ValidationException(String.format(BaseCli.RESOURCE_BUNDLE.getString("error.config.enum_wrong_value"), key, acceptableValuesEnum));
        }
    }

    protected static boolean checkBasePathExists(String basePath) {
        return Files.exists(Paths.get(basePath, new String[0]), new LinkOption[0]);
    }

    protected static boolean checkBasePathIsDir(String basePath) {
        return Files.isDirectory(Paths.get(basePath, new String[0]), new LinkOption[0]);
    }

    protected static boolean checkForDoubleAsterisks(String source, String translation) {
        return !StringUtils.contains((CharSequence)translation, "**") || StringUtils.contains((CharSequence)source, "**");
    }

    protected static boolean hasRelativePaths(String path) {
        return StringUtils.containsAny((CharSequence)path, "../", "/./");
    }

    static class Messages {
        private List<String> errors = new ArrayList<String>();
        private List<String> warnings = new ArrayList<String>();

        Messages() {
        }

        public void addError(String error) {
            this.errors.add(error);
        }

        public void addAllErrors(List<String> errors) {
            this.errors.addAll(errors);
        }

        public void addWarning(String warning) {
            this.warnings.add(warning);
        }

        public void populate(Messages other) {
            this.errors.addAll(other.errors);
            this.warnings.addAll(other.warnings);
        }

        public List<String> getErrors() {
            return this.errors;
        }

        public List<String> getWarnings() {
            return this.warnings;
        }
    }
}

