/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties.helper;

import com.crowdin.cli.properties.helper.FileMatcher;
import com.crowdin.cli.utils.Utils;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.filefilter.RegexFileFilter;

public class FileHelper {
    private static final String DOUBLED_ASTERISK = "**";
    private static final String REGEX = "regex";
    private static final String ASTERISK = "*";
    private static final String QUESTION_MARK = "?";
    private static final String DOT = ".";
    private static final String DOT_PLUS = ".+";
    private static final String SET_OPEN_BRACKET = "[";
    private static final String SET_CLOSE_BRACKET = "]";
    private static final String ROUND_BRACKET_OPEN = "(";
    private static final String ROUND_BRACKET_CLOSE = ")";
    private static final String ESCAPE_ROUND_BRACKET_OPEN = "\\(";
    private static final String ESCAPE_ROUND_BRACKET_CLOSE = "\\)";
    private static final String ESCAPE_DOT = "\\.";
    private static final String ESCAPE_DOT_PLACEHOLDER = "{ESCAPE_DOT}";
    private static final String ESCAPE_QUESTION = "\\?";
    private static final String ESCAPE_QUESTION_PLACEHOLDER = "{ESCAPE_QUESTION_MARK}";
    private static final String ESCAPE_ASTERISK = "\\*";
    private static final String ESCAPE_ASTERISK_PLACEHOLDER = "{ESCAPE_ASTERISK}";
    private static final String PLUS = "+";
    private static final String ESCAPE_PLUS = "\\+";
    private final String basePath;

    public FileHelper(String basePath) {
        if (basePath == null) {
            throw new NullPointerException("in FileHelper.constructor");
        }
        this.basePath = basePath;
    }

    public List<File> getFiles(String source) {
        if (source == null) {
            throw new NullPointerException("NPE in FileHelper.getFiles");
        }
        Set<File> resultList = new HashSet<File>();
        String[] nodes = Utils.normalizePath(source).split(Utils.PATH_SEPARATOR_REGEX);
        resultList.add(new File(this.basePath));
        for (String node : nodes) {
            if (!node.isEmpty() && (resultList = DOUBLED_ASTERISK.equals(node) ? this.findFiles(resultList, node) : this.findFiles(resultList, this.translateToRegex(node))).isEmpty()) break;
        }
        return new ArrayList<File>(resultList);
    }

    public List<File> filterOutIgnoredFiles(List<File> sources, List<String> ignores) {
        if (sources == null || ignores == null) {
            throw new NullPointerException("NPE in FileHelper.filterOutIgnoredFiles");
        }
        ArrayList<FileMatcher> matchers = new ArrayList<FileMatcher>(ignores.size());
        for (String pattern : ignores) {
            if (new File(this.basePath + pattern).isDirectory()) {
                matchers.add(new FileMatcher(pattern + Utils.PATH_SEPARATOR + ASTERISK, this.basePath));
                matchers.add(new FileMatcher(pattern + Utils.PATH_SEPARATOR + DOUBLED_ASTERISK + Utils.PATH_SEPARATOR + ASTERISK, this.basePath));
                continue;
            }
            matchers.add(new FileMatcher(pattern, this.basePath));
            if (!pattern.contains(DOUBLED_ASTERISK)) continue;
            matchers.add(new FileMatcher(pattern.replace(DOUBLED_ASTERISK + Utils.PATH_SEPARATOR, ""), this.basePath));
        }
        return sources.stream().filter(source -> matchers.stream().noneMatch(m -> m.matches((File)source))).collect(Collectors.toList());
    }

    private String translateToRegex(String node) {
        node = node.replace(ESCAPE_DOT, ESCAPE_DOT_PLACEHOLDER).replace(DOT, ESCAPE_DOT).replace(ESCAPE_DOT_PLACEHOLDER, ESCAPE_DOT);
        node = node.replace(ESCAPE_QUESTION, ESCAPE_QUESTION_PLACEHOLDER).replace(QUESTION_MARK, DOT).replace(ESCAPE_QUESTION_PLACEHOLDER, ESCAPE_QUESTION);
        node = node.replace(PLUS, ESCAPE_PLUS);
        node = node.replace(ESCAPE_ASTERISK, ESCAPE_ASTERISK_PLACEHOLDER).replace(ASTERISK, DOT_PLUS).replace(ESCAPE_ASTERISK_PLACEHOLDER, ESCAPE_ASTERISK);
        node = node.replace(ROUND_BRACKET_OPEN, ESCAPE_ROUND_BRACKET_OPEN);
        node = node.replace(ROUND_BRACKET_CLOSE, ESCAPE_ROUND_BRACKET_CLOSE);
        return node;
    }

    private Set<File> findFiles(Set<File> paths, String node) {
        HashSet<File> result = new HashSet<File>();
        for (File file : paths) {
            RegexFileFilter fileFilter;
            File[] files;
            if (!file.exists()) continue;
            if (DOUBLED_ASTERISK.equals(node)) {
                result.addAll(this.getListDirectory(file));
                continue;
            }
            if (!file.isDirectory() || (files = file.listFiles(fileFilter = new RegexFileFilter(node))) == null) continue;
            result.addAll(Arrays.asList(files));
        }
        return result;
    }

    private List<File> getListDirectory(File directory) {
        ArrayList<File> resultList = new ArrayList<File>();
        resultList.add(directory);
        File[] fileList = directory.listFiles();
        if (fileList != null) {
            for (File file : fileList) {
                if (!Files.isDirectory(file.toPath(), LinkOption.NOFOLLOW_LINKS)) continue;
                resultList.addAll(this.getListDirectory(file));
            }
        }
        return resultList;
    }
}

