/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.properties.helper;

import com.crowdin.cli.utils.Utils;
import java.io.File;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;

class FileMatcher
implements PathMatcher {
    private final PathMatcher delegate;

    FileMatcher(String pattern, String basePath) {
        if (basePath != null) {
            if (!basePath.trim().endsWith(Utils.PATH_SEPARATOR) && !((String)pattern).trim().startsWith(Utils.PATH_SEPARATOR)) {
                pattern = basePath + Utils.PATH_SEPARATOR + (String)pattern;
            } else {
                pattern = basePath.trim() + ((String)pattern).trim();
                pattern = ((String)pattern).replace(Utils.PATH_SEPARATOR_REGEX + Utils.PATH_SEPARATOR_REGEX, Utils.PATH_SEPARATOR_REGEX);
            }
        }
        pattern = ((String)pattern).replaceAll("\\\\+", Utils.PATH_SEPARATOR_REGEX + Utils.PATH_SEPARATOR_REGEX);
        pattern = ((String)pattern).replaceAll("/+", "/");
        pattern = ((String)pattern).replaceAll("\\{\\{+", "\\\\{\\\\{");
        pattern = ((String)pattern).replaceAll("}}+", "\\\\}\\\\}");
        this.delegate = FileSystems.getDefault().getPathMatcher("glob:" + (String)pattern);
    }

    @Override
    public boolean matches(Path path) {
        return this.delegate.matches(path);
    }

    boolean matches(File file) {
        return this.matches(file.toPath());
    }
}

