/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils;

import com.crowdin.cli.client.LanguageMapping;
import com.crowdin.cli.utils.Utils;
import com.crowdin.client.languages.model.Language;
import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class PlaceholderUtil {
    public static final String PLACEHOLDER_ANDROID_CODE = "%android_code%";
    public static final String PLACEHOLDER_LANGUAGE = "%language%";
    public static final String PLACEHOLDER_LOCALE = "%locale%";
    public static final String PLACEHOLDER_LOCALE_WITH_UNDERSCORE = "%locale_with_underscore%";
    public static final String PLACEHOLDER_THREE_LETTERS_CODE = "%three_letters_code%";
    public static final String PLACEHOLDER_TWO_LETTERS_CODE = "%two_letters_code%";
    public static final String PLACEHOLDER_OSX_CODE = "%osx_code%";
    public static final String PLACEHOLDER_OSX_LOCALE = "%osx_locale%";
    public static final String PLACEHOLDER_LANGUAGE_ID = "%language_id%";
    public static final String PLACEHOLDER_NAME_ANDROID_CODE = "android_code";
    public static final String PLACEHOLDER_NAME_LANGUAGE = "language";
    public static final String PLACEHOLDER_NAME_LANGUAGE_2 = "name";
    public static final String PLACEHOLDER_NAME_LOCALE = "locale";
    public static final String PLACEHOLDER_NAME_LOCALE_WITH_UNDERSCORE = "locale_with_underscore";
    public static final String PLACEHOLDER_NAME_THREE_LETTERS_CODE = "three_letters_code";
    public static final String PLACEHOLDER_NAME_TWO_LETTERS_CODE = "two_letters_code";
    public static final String PLACEHOLDER_NAME_OSX_CODE = "osx_code";
    public static final String PLACEHOLDER_NAME_OSX_LOCALE = "osx_locale";
    public static final String PLACEHOLDER_NAME_LANGUAGE_ID = "language_id";
    public static final String PLACEHOLDER_FILE_EXTENSION = "%file_extension%";
    public static final String PLACEHOLDER_FILE_NAME = "%file_name%";
    public static final String PLACEHOLDER_ORIGINAL_FILE_NAME = "%original_file_name%";
    public static final String PLACEHOLDER_ORIGINAL_PATH = "%original_path%";
    public static final List<String> ALL_PLACEHOLDERS = List.of("%file_extension%", "%file_name%", "%original_file_name%", "%original_path%", "%android_code%", "%language%", "%locale%", "%locale_with_underscore%", "%three_letters_code%", "%two_letters_code%", "%osx_code%", "%osx_locale%", "%language_id%");
    public static final List<String> FILE_PLACEHOLDERS = List.of("%file_extension%", "%file_name%", "%original_file_name%", "%original_path%");
    public static final String DOUBLED_ASTERISK = "**";
    private static final String REGEX = "regex";
    private static final String ASTERISK = "*";
    private static final String QUESTION_MARK = "?";
    private static final String DOT = ".";
    private static final String DOT_PLUS = ".+";
    private static final String SET_OPEN_BRACKET = "[";
    private static final String SET_CLOSE_BRACKET = "]";
    public static final String PLUS = "+";
    public static final String PLUS_REGEX = "\\+";
    public static final String ROUND_BRACKET_OPEN = "(";
    public static final String ROUND_BRACKET_CLOSE = ")";
    public static final String ESCAPE_ROUND_BRACKET_OPEN = Utils.isWindows() != false ? "^(" : "\\(";
    public static final String ESCAPE_ROUND_BRACKET_CLOSE = Utils.isWindows() != false ? "^)" : "\\)";
    private static final String ESCAPE_DOT = Utils.isWindows() != false ? "^." : "\\.";
    private static final String ESCAPE_DOT_REGEX = "\\.";
    private static final String ESCAPE_DOT_PLACEHOLDER = "{ESCAPE_DOT}";
    private static final String ESCAPE_QUESTION = Utils.isWindows() != false ? "^?" : "\\?";
    private static final String ESCAPE_QUESTION_REGEX = "\\?";
    private static final String ESCAPE_QUESTION_PLACEHOLDER = "{ESCAPE_QUESTION_MARK}";
    private static final String ESCAPE_ASTERISK = Utils.isWindows() != false ? "^*" : "\\*";
    private static final String ESCAPE_ASTERISK_REGEX = "\\*";
    private static final String ESCAPE_ASTERISK_PLACEHOLDER = "{ESCAPE_ASTERISK}";
    private static final String ESCAPE_ASTERISK_REPLACEMENT_FROM = ".+" + Utils.PATH_SEPARATOR_REGEX;
    private static final String ESCAPE_ASTERISK_REPLACEMENT_TO = "(.+" + Utils.PATH_SEPARATOR_REGEX + ")?";
    private List<Language> supportedLanguages;
    private List<Language> projectLanguages;
    private String basePath;

    public PlaceholderUtil(List<Language> supportedLanguages, List<Language> projectLanguages, String basePath) {
        if (supportedLanguages == null || projectLanguages == null || basePath == null) {
            throw new NullPointerException("in PlaceholderUtil.constructor");
        }
        this.supportedLanguages = supportedLanguages;
        this.projectLanguages = projectLanguages;
        this.basePath = basePath;
    }

    public List<String> format(List<File> sources, List<String> toFormat) {
        if (sources == null || toFormat == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String str : toFormat) {
            res.addAll(this.format(sources, str, null));
        }
        return res;
    }

    public List<String> format(List<File> sources, List<String> toFormat, LanguageMapping languageMapping) {
        if (sources == null || toFormat == null) {
            return new ArrayList<String>();
        }
        ArrayList<String> res = new ArrayList<String>();
        for (String str : toFormat) {
            res.addAll(this.format(sources, str, languageMapping));
        }
        return res;
    }

    public Set<String> format(List<File> sources, String toFormat, LanguageMapping languageMapping) {
        if (sources == null || toFormat == null) {
            return new HashSet<String>();
        }
        return this.supportedLanguages.stream().map(lang -> languageMapping == null ? this.replaceLanguageDependentPlaceholders(toFormat, (Language)lang) : this.replaceLanguageDependentPlaceholders(toFormat, languageMapping, (Language)lang)).flatMap(changedToFormat -> sources.stream().map(source -> this.replaceFileDependentPlaceholders((String)changedToFormat, (File)source))).collect(Collectors.toSet());
    }

    public Set<String> format(List<File> sources, String toFormat) {
        return this.format(sources, toFormat, null);
    }

    public String replaceLanguageDependentPlaceholders(String toFormat, Language lang) {
        if (toFormat == null || lang == null) {
            throw new NullPointerException("null args in replaceLanguageDependentPlaceholders()");
        }
        toFormat = toFormat.contains(PLACEHOLDER_LANGUAGE_ID) ? toFormat.replace(PLACEHOLDER_LANGUAGE_ID, lang.getId()) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_LANGUAGE) ? toFormat.replace(PLACEHOLDER_LANGUAGE, lang.getName()) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_LOCALE) ? toFormat.replace(PLACEHOLDER_LOCALE, lang.getLocale()) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_LOCALE_WITH_UNDERSCORE) ? toFormat.replace(PLACEHOLDER_LOCALE_WITH_UNDERSCORE, lang.getLocale().replace("-", "_")) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_TWO_LETTERS_CODE) ? toFormat.replace(PLACEHOLDER_TWO_LETTERS_CODE, lang.getTwoLettersCode()) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_THREE_LETTERS_CODE) ? toFormat.replace(PLACEHOLDER_THREE_LETTERS_CODE, lang.getThreeLettersCode()) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_ANDROID_CODE) ? toFormat.replace(PLACEHOLDER_ANDROID_CODE, lang.getAndroidCode()) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_OSX_LOCALE) ? toFormat.replace(PLACEHOLDER_OSX_LOCALE, lang.getOsxLocale()) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_OSX_CODE) ? toFormat.replace(PLACEHOLDER_OSX_CODE, lang.getOsxCode()) : toFormat;
        return toFormat;
    }

    public List<String> replaceLanguageDependentPlaceholders(String toFormat, LanguageMapping languageMapping) {
        return this.projectLanguages.stream().map(lang -> this.replaceLanguageDependentPlaceholders(toFormat, languageMapping, (Language)lang)).collect(Collectors.toList());
    }

    public String replaceLanguageDependentPlaceholders(String toFormat, LanguageMapping langMapping, Language lang) {
        if (toFormat == null || lang == null || langMapping == null) {
            throw new NullPointerException("null args in replaceLanguageDependentPlaceholders()");
        }
        toFormat = toFormat.contains(PLACEHOLDER_LANGUAGE_ID) ? toFormat.replace(PLACEHOLDER_LANGUAGE_ID, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_LANGUAGE_ID, lang.getId())) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_LANGUAGE) ? toFormat.replace(PLACEHOLDER_LANGUAGE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_LANGUAGE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_LANGUAGE_2, lang.getName()))) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_LOCALE) ? toFormat.replace(PLACEHOLDER_LOCALE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_LOCALE, lang.getLocale())) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_LOCALE_WITH_UNDERSCORE) ? toFormat.replace(PLACEHOLDER_LOCALE_WITH_UNDERSCORE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_LOCALE_WITH_UNDERSCORE, lang.getLocale().replace("-", "_"))) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_TWO_LETTERS_CODE) ? toFormat.replace(PLACEHOLDER_TWO_LETTERS_CODE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_TWO_LETTERS_CODE, lang.getTwoLettersCode())) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_THREE_LETTERS_CODE) ? toFormat.replace(PLACEHOLDER_THREE_LETTERS_CODE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_THREE_LETTERS_CODE, lang.getThreeLettersCode())) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_ANDROID_CODE) ? toFormat.replace(PLACEHOLDER_ANDROID_CODE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_ANDROID_CODE, lang.getAndroidCode())) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_OSX_LOCALE) ? toFormat.replace(PLACEHOLDER_OSX_LOCALE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_OSX_LOCALE, lang.getOsxLocale())) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_OSX_CODE) ? toFormat.replace(PLACEHOLDER_OSX_CODE, langMapping.getValueOrDefault(lang.getId(), PLACEHOLDER_NAME_OSX_CODE, lang.getOsxCode())) : toFormat;
        return toFormat;
    }

    public String replaceFileDependentPlaceholders(String toFormat, File file) {
        if (toFormat == null || file == null) {
            throw new NullPointerException("null args in replaceFileDependentPlaceholders()");
        }
        String fileName = file.getName();
        String fileNameWithoutExt = FilenameUtils.removeExtension(fileName);
        String fileExt = FilenameUtils.getExtension(fileName);
        String tempBasePath = this.basePath;
        String fileParent = Utils.noSepAtEnd(StringUtils.removeStart((String)(file.getParent() != null ? file.getParent() + Utils.PATH_SEPARATOR : ""), tempBasePath));
        toFormat = toFormat.contains(PLACEHOLDER_ORIGINAL_FILE_NAME) ? toFormat.replace(PLACEHOLDER_ORIGINAL_FILE_NAME, fileName) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_FILE_NAME) ? toFormat.replace(PLACEHOLDER_FILE_NAME, fileNameWithoutExt) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_FILE_EXTENSION) ? toFormat.replace(PLACEHOLDER_FILE_EXTENSION, fileExt) : toFormat;
        toFormat = toFormat.contains(PLACEHOLDER_ORIGINAL_PATH) ? toFormat.replace(PLACEHOLDER_ORIGINAL_PATH, fileParent) : toFormat;
        if ((toFormat = toFormat.replace("/", File.separator)).contains(DOUBLED_ASTERISK)) {
            String prefixFormat = StringUtils.substringBefore(toFormat, DOUBLED_ASTERISK);
            String substringAfter = StringUtils.substringAfter(toFormat, DOUBLED_ASTERISK);
            if (substringAfter.length() > 1 && !file.getPath().endsWith(substringAfter) && file.getPath().contains(substringAfter)) {
                int lastIndexOf = file.getPath().lastIndexOf(substringAfter);
                String lastPart = file.getPath().substring(lastIndexOf + substringAfter.length());
                substringAfter = Utils.joinPaths(substringAfter, lastPart);
            }
            String postfix = Utils.getParentDirectory(substringAfter);
            String prefix = prefixFormat.length() > 1 && file.getPath().contains(prefixFormat) ? StringUtils.substringBefore(fileParent, Utils.noSepAtStart(prefixFormat)) : "";
            String doubleAsterisks = StringUtils.removeStart(Utils.noSepAtStart(StringUtils.removeStart(fileParent, prefix)), Utils.noSepAtEnd(Utils.noSepAtStart(prefixFormat)));
            doubleAsterisks = postfix.length() > 1 ? StringUtils.removeEnd(doubleAsterisks, Utils.noSepAtEnd(postfix)) : doubleAsterisks;
            toFormat = toFormat.replace(DOUBLED_ASTERISK, doubleAsterisks);
        }
        toFormat = toFormat.replaceAll("[\\\\/]+", Utils.PATH_SEPARATOR_REGEX);
        return StringUtils.removeStart(toFormat, Utils.PATH_SEPARATOR);
    }

    public List<String> formatForRegex(List<String> toFormat) {
        String langIds = this.supportedLanguages.stream().map(Language::getId).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        String langNames = this.supportedLanguages.stream().map(Language::getName).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        String langLocales = this.supportedLanguages.stream().map(Language::getLocale).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        String langLocalesWithUnderscore = this.supportedLanguages.stream().map(Language::getLocale).map(s -> s.replace("-", "_")).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        String langTwoLettersCodes = this.supportedLanguages.stream().map(Language::getTwoLettersCode).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        String langThreeLettersCodes = this.supportedLanguages.stream().map(Language::getThreeLettersCode).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        String langAndroidCodes = this.supportedLanguages.stream().map(Language::getAndroidCode).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        String langOsxLocales = this.supportedLanguages.stream().map(Language::getOsxLocale).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        String langOsxCodes = this.supportedLanguages.stream().map(Language::getOsxCode).collect(Collectors.joining("|", ROUND_BRACKET_OPEN, ROUND_BRACKET_CLOSE));
        return toFormat.stream().map(PlaceholderUtil::formatSourcePatternForRegex).map(s -> s.replace(PLACEHOLDER_LANGUAGE_ID, langIds).replace(PLACEHOLDER_LANGUAGE, langNames).replace(PLACEHOLDER_LOCALE, langLocales).replace(PLACEHOLDER_LOCALE_WITH_UNDERSCORE, langLocalesWithUnderscore).replace(PLACEHOLDER_TWO_LETTERS_CODE, langTwoLettersCodes).replace(PLACEHOLDER_THREE_LETTERS_CODE, langThreeLettersCodes).replace(PLACEHOLDER_ANDROID_CODE, langAndroidCodes).replace(PLACEHOLDER_OSX_LOCALE, langOsxLocales).replace(PLACEHOLDER_OSX_CODE, langOsxCodes)).map(s -> "^" + s + "$").collect(Collectors.toList());
    }

    public static String formatSourcePatternForRegex(String toFormat) {
        if (Utils.isWindows().booleanValue()) {
            toFormat = toFormat.replace("\\", "\\\\");
        }
        toFormat = toFormat.replace(ESCAPE_DOT, ESCAPE_DOT_PLACEHOLDER).replace(DOT, ESCAPE_DOT_REGEX).replace(ESCAPE_DOT_PLACEHOLDER, ESCAPE_DOT).replace(ESCAPE_QUESTION, ESCAPE_QUESTION_PLACEHOLDER).replace(QUESTION_MARK, "[^/]").replace(ESCAPE_QUESTION_PLACEHOLDER, ESCAPE_QUESTION);
        toFormat = toFormat.replace(ESCAPE_ASTERISK, ESCAPE_ASTERISK_PLACEHOLDER).replace(DOUBLED_ASTERISK, DOT_PLUS).replace(ESCAPE_ASTERISK_PLACEHOLDER, ESCAPE_ASTERISK).replace(ESCAPE_ASTERISK, ESCAPE_ASTERISK_PLACEHOLDER).replace(ASTERISK, "[^/]+").replace(ESCAPE_ASTERISK_PLACEHOLDER, ESCAPE_ASTERISK);
        toFormat = toFormat.replace(ROUND_BRACKET_OPEN, ESCAPE_ROUND_BRACKET_OPEN).replace(ROUND_BRACKET_CLOSE, ESCAPE_ROUND_BRACKET_CLOSE).replace(ESCAPE_ASTERISK_REPLACEMENT_FROM, ESCAPE_ASTERISK_REPLACEMENT_TO);
        if (Utils.isWindows().booleanValue()) {
            toFormat = toFormat.replace(ESCAPE_ASTERISK, ESCAPE_ASTERISK_REGEX).replace(ESCAPE_DOT, ESCAPE_DOT_REGEX).replace(ESCAPE_QUESTION, ESCAPE_QUESTION_REGEX);
        }
        return toFormat.replace(PLACEHOLDER_FILE_EXTENSION, "[^/]+").replace(PLACEHOLDER_FILE_NAME, "[^/]+").replace(PLACEHOLDER_ORIGINAL_FILE_NAME, "[^/]+").replace(PLACEHOLDER_ORIGINAL_PATH, DOT_PLUS);
    }

    public static boolean containsFilePlaceholders(String pattern) {
        return StringUtils.containsAny((CharSequence)pattern, PLACEHOLDER_FILE_EXTENSION, PLACEHOLDER_FILE_NAME, PLACEHOLDER_ORIGINAL_FILE_NAME, PLACEHOLDER_ORIGINAL_PATH);
    }

    public static boolean containsLangPlaceholders(String translationsPattern) {
        return StringUtils.containsAny((CharSequence)translationsPattern, PLACEHOLDER_LANGUAGE, PLACEHOLDER_TWO_LETTERS_CODE, PLACEHOLDER_THREE_LETTERS_CODE, PLACEHOLDER_LOCALE_WITH_UNDERSCORE, PLACEHOLDER_LOCALE, PLACEHOLDER_ANDROID_CODE, PLACEHOLDER_OSX_CODE, PLACEHOLDER_OSX_LOCALE);
    }

    public static boolean validStringPattern(String translationsPattern, List<String> patterns) {
        String[] parts;
        for (String part : parts = translationsPattern.split("/")) {
            if (!part.endsWith("%") || !part.startsWith("%") || patterns.contains(part)) continue;
            return false;
        }
        return true;
    }
}

