/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.cache;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.utils.Utils;
import com.crowdin.cli.utils.console.ExecutionStatus;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.json.JSONObject;

public class Cache {
    private static final String CACHE_LOCATION = System.getProperty("user.home") + Utils.PATH_SEPARATOR + ".crowdin" + Utils.PATH_SEPARATOR + "cache.json";
    private static JSONObject CACHE = new JSONObject();

    public static void initialize(boolean plainView, Outputter out) {
        try {
            if (!Files.exists(Paths.get(CACHE_LOCATION, new String[0]), new LinkOption[0])) {
                return;
            }
            String json = String.join((CharSequence)"", Files.readAllLines(Paths.get(CACHE_LOCATION, new String[0])));
            CACHE = new JSONObject(json);
        }
        catch (Exception e) {
            if (!plainView) {
                out.println(ExecutionStatus.ERROR.withIcon(BaseCli.RESOURCE_BUNDLE.getString("error.cache_init")));
            }
            out.println(BaseCli.RESOURCE_BUNDLE.getString("error.cache_init"));
        }
    }

    public static void save(boolean plainView, Outputter out) {
        try {
            Files.createDirectories(Paths.get(CACHE_LOCATION, new String[0]).getParent(), new FileAttribute[0]);
            Files.write(Paths.get(CACHE_LOCATION, new String[0]), CACHE.toString(4).getBytes(), new OpenOption[0]);
        }
        catch (Exception e) {
            if (!plainView) {
                out.println(ExecutionStatus.ERROR.withIcon(BaseCli.RESOURCE_BUNDLE.getString("error.cache_save")));
            }
            out.println(BaseCli.RESOURCE_BUNDLE.getString("error.cache_save"));
        }
    }

    public static Map<String, String> getSourceHashes() {
        if (!CACHE.has("sourceHashes")) {
            CACHE.put("sourceHashes", new HashMap());
        }
        JSONObject obj = CACHE.getJSONObject("sourceHashes");
        return obj.toMap().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> e.getValue().toString()));
    }

    public static void setSourceHashes(Map<String, String> sourceHashes) {
        CACHE.put("sourceHashes", sourceHashes);
    }
}

