/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.concurrency;

import com.crowdin.cli.utils.concurrency.CrowdinExecutorService;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

public class ConcurrencyUtil {
    private static final int CROWDIN_API_MAX_CONCURRENT_REQUESTS = 4;

    private ConcurrencyUtil() {
        throw new UnsupportedOperationException();
    }

    public static void executeAndWait(List<Runnable> tasks, boolean debug) {
        ConcurrencyUtil.run(tasks, 4, tasks.size() * 2, debug);
    }

    public static void executeAndWaitSingleThread(List<Runnable> tasks, boolean debug) {
        ConcurrencyUtil.run(tasks, 1, 100, debug);
    }

    private static void run(List<Runnable> tasks, int threadQnt, int minutesWait, boolean debug) {
        if (Objects.isNull(tasks) || tasks.isEmpty()) {
            return;
        }
        ExecutorService executor = CrowdinExecutorService.newFixedThreadPool(threadQnt, debug);
        tasks.forEach(executor::submit);
        executor.shutdown();
        try {
            if (!executor.awaitTermination(minutesWait, TimeUnit.MINUTES)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException ex) {
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

