/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.console;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.commands.Outputter;
import com.crowdin.cli.commands.picocli.ExitCodeExceptionMapper;
import com.crowdin.cli.utils.console.ExecutionStatus;
import com.crowdin.cli.utils.console.Spinner;
import java.util.concurrent.Callable;
import lombok.NonNull;

public class ConsoleSpinner {
    private static final Object object = new Object();
    private static Spinner worker;

    public static <T> T execute(Outputter out, String waitingMessageKey, String errorMessageKey, boolean noProgress, boolean isPlain, @NonNull Callable<T> callable) {
        if (callable == null) {
            throw new NullPointerException("callable is marked non-null but is null");
        }
        try {
            if (!isPlain) {
                ConsoleSpinner.start(out, BaseCli.RESOURCE_BUNDLE.getString(waitingMessageKey), noProgress);
            }
            T result = callable.call();
            ConsoleSpinner.stop(ExecutionStatus.OK);
            return result;
        }
        catch (Exception e) {
            ConsoleSpinner.stop(ExecutionStatus.ERROR);
            throw ExitCodeExceptionMapper.remap(e, BaseCli.RESOURCE_BUNDLE.getString(errorMessageKey));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start(Outputter out, String contextMessage, boolean noProgress) {
        Object object = ConsoleSpinner.object;
        synchronized (object) {
            ConsoleSpinner.stop(ExecutionStatus.EMPTY);
            worker = new Spinner(out, contextMessage, noProgress);
            worker.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(String contextMessage) {
        Object object = ConsoleSpinner.object;
        synchronized (object) {
            if (worker == null) {
                return;
            }
            worker.setMessage(contextMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(ExecutionStatus status) {
        Object object = ConsoleSpinner.object;
        synchronized (object) {
            if (worker == null) {
                return;
            }
            worker.stopSpinning(status);
            worker = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void stop(ExecutionStatus status, String message) {
        Object object = ConsoleSpinner.object;
        synchronized (object) {
            if (worker == null) {
                return;
            }
            worker.stopSpinning(status, message);
            worker = null;
        }
    }
}

