/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.file;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.utils.console.ExecutionStatus;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.yaml.snakeyaml.Yaml;

public class FileUtils {
    private static final String YAML_EXTENSION = ".yaml";
    private static final String YML_EXTENSION = ".yml";

    public static Map<String, Object> readYamlFile(File fileCfg) {
        Map map;
        if (fileCfg == null) {
            throw new NullPointerException("FileReader.readCliConfig has null args");
        }
        if (!fileCfg.getName().endsWith(YAML_EXTENSION) && !fileCfg.getName().endsWith(YML_EXTENSION)) {
            System.out.println(ExecutionStatus.WARNING.withIcon(String.format(BaseCli.RESOURCE_BUNDLE.getString("message.warning.not_yml"), fileCfg.getAbsolutePath())));
        }
        Yaml yaml = new Yaml();
        FileInputStream inputStream = new FileInputStream(fileCfg);
        try {
            map = (Map)yaml.load(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.configuration_file_not_exist"));
            }
            catch (Exception e) {
                throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.reading_configuration_file"), e);
            }
        }
        ((InputStream)inputStream).close();
        return map;
    }

    public static void writeToFile(InputStream data, String filePath) throws IOException {
        Path parentDirectory = Paths.get(filePath, new String[0]).getParent();
        if (parentDirectory != null) {
            Files.createDirectories(parentDirectory, new FileAttribute[0]);
        }
        FileOutputStream fileOutputStream = new FileOutputStream(filePath);
        IOUtils.copy(data, (OutputStream)fileOutputStream);
        fileOutputStream.flush();
        fileOutputStream.close();
    }

    public static String computeChecksum(Path path) throws IOException, NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        try (InputStream is = Files.newInputStream(path, new OpenOption[0]);
             DigestInputStream dis = new DigestInputStream(is, md);){
            byte[] buffer = new byte[8192];
            while (dis.read(buffer) != -1) {
            }
        }
        byte[] digest = md.digest();
        StringBuilder sb = new StringBuilder(digest.length * 2);
        for (byte b : digest) {
            sb.append(String.format("%02x", b));
        }
        return sb.toString();
    }
}

