/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.http;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

class HttpRequest {
    private String method;
    private String path;
    private Map<String, String> params;
    private Map<String, String> headers;
    private String data;

    public static HttpRequest parse(BufferedReader reader) {
        try {
            char[] charArray;
            HttpRequest request = new HttpRequest();
            String line = reader.readLine();
            if (line != null && !line.equals("")) {
                String[] firstLine = line.split(" ");
                if (firstLine.length >= 1) {
                    request.setMethod(firstLine[0]);
                }
                HashMap<String, String> params = new HashMap<String, String>();
                if (firstLine.length >= 2) {
                    String[] path = firstLine[1].split("\\?", 2);
                    request.setPath(path[0]);
                    if (path.length > 1) {
                        String[] paramsStr;
                        for (String param : paramsStr = path[1].split("&")) {
                            String[] paramEntry = param.split("=", 2);
                            if (paramEntry.length <= 1) continue;
                            params.put(paramEntry[0], paramEntry[1]);
                        }
                    }
                }
                request.setParams(params);
            }
            HashMap<String, String> headers = new HashMap<String, String>();
            while ((line = reader.readLine()) != null && !line.equals("")) {
                String[] header = line.split(": ", 2);
                if (header.length == 2) {
                    headers.put(header[0], header[1]);
                    continue;
                }
                System.out.println(String.format("Couldn't parse header from line '%s'", line));
            }
            request.setHeaders(headers);
            int contentLength = Integer.parseInt(request.getHeaders().getOrDefault("Content-Length", "-1"));
            if (contentLength > 0 && reader.read(charArray = new char[contentLength], 0, contentLength) != -1) {
                String postData = new String(charArray);
                request.setData(postData);
            }
            return request;
        }
        catch (IOException e) {
            throw new RuntimeException("Error while parsing request", e);
        }
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public Map<String, String> getParams() {
        return this.params;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public String getData() {
        return this.data;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setParams(Map<String, String> params) {
        this.params = params;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public void setData(String data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpRequest)) {
            return false;
        }
        HttpRequest other = (HttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        Map<String, String> this$params = this.getParams();
        Map<String, String> other$params = other.getParams();
        if (this$params == null ? other$params != null : !((Object)this$params).equals(other$params)) {
            return false;
        }
        Map<String, String> this$headers = this.getHeaders();
        Map<String, String> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$data = this.getData();
        String other$data = other.getData();
        return !(this$data == null ? other$data != null : !this$data.equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        Map<String, String> $params = this.getParams();
        result = result * 59 + ($params == null ? 43 : ((Object)$params).hashCode());
        Map<String, String> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        return result;
    }

    public String toString() {
        return "HttpRequest(method=" + this.getMethod() + ", path=" + this.getPath() + ", params=" + String.valueOf(this.getParams()) + ", headers=" + String.valueOf(this.getHeaders()) + ", data=" + this.getData() + ")";
    }

    protected HttpRequest(String method, String path, Map<String, String> params, Map<String, String> headers, String data) {
        this.method = method;
        this.path = path;
        this.params = params;
        this.headers = headers;
        this.data = data;
    }

    protected HttpRequest() {
    }
}

