/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.cli.utils.http;

import com.crowdin.cli.BaseCli;
import com.crowdin.cli.utils.OutputUtil;
import com.crowdin.cli.utils.http.HttpListener;
import com.crowdin.cli.utils.http.HttpRequest;
import com.crowdin.cli.utils.http.HttpResponse;
import com.crowdin.cli.utils.http.ServerSocketFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

class SimpleHttpServer
extends Thread {
    private final ServerSocketFactory factory;
    private final int port;
    private final boolean debug;
    private final Map<String, HttpListener> listeners = new ConcurrentHashMap<String, HttpListener>();
    private ServerSocket serverSocket;
    private HttpListener defaultListener = (request, responseOut) -> {
        HttpResponse.notFoundHtml("<h1>404 Not Found!</h1>").send(responseOut);
        String method = request.getMethod() != null ? request.getMethod() : "<no_method>";
        String path = request.getPath() != null ? request.getPath() : "<no_path>";
        System.out.println(String.format("Unexpected %s request to '%s'", method, path));
    };

    public SimpleHttpServer(ServerSocketFactory factory, int port, boolean debug) {
        this.factory = factory;
        this.port = port;
        this.debug = debug;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try (ServerSocket serverSocket = this.factory.get(this.port);){
            this.serverSocket = serverSocket;
            while (!serverSocket.isClosed()) {
                Socket socket = serverSocket.accept();
                try (BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream(), StandardCharsets.UTF_8));
                     PrintWriter out = new PrintWriter(new OutputStreamWriter(socket.getOutputStream(), StandardCharsets.UTF_8));){
                    HttpRequest request = HttpRequest.parse(in);
                    if (request.getPath() != null && this.listeners.containsKey(request.getPath())) {
                        this.listeners.get(request.getPath()).accept(request, out);
                        continue;
                    }
                    if (this.defaultListener == null) continue;
                    this.defaultListener.accept(request, out);
                }
                catch (IOException e) {
                    throw new RuntimeException(BaseCli.RESOURCE_BUNDLE.getString("error.in_local_server"), e);
                    return;
                }
            }
        }
        catch (SocketException e) {
            if (e.getMessage() != null && e.getMessage().contains("Socket closed")) return;
            OutputUtil.fancyErr((Throwable)e, System.err, this.debug);
            return;
        }
        catch (Exception e) {
            OutputUtil.fancyErr((Throwable)e, System.err, this.debug);
        }
    }

    public void close() {
        try {
            this.interrupt();
            this.serverSocket.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while closing local server", e);
        }
    }

    public void addListener(String path, HttpListener listener) {
        this.listeners.put(path, listener);
    }

    public void setDefaultListener(HttpListener defaultListener) {
        this.defaultListener = defaultListener;
    }
}

