/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.ai;

import com.crowdin.client.ai.model.AiPrompt;
import com.crowdin.client.ai.model.AiPromptAddRequest;
import com.crowdin.client.ai.model.AiPromptCloneRequest;
import com.crowdin.client.ai.model.AiPromptCompletionRequest;
import com.crowdin.client.ai.model.AiPromptCompletionResponse;
import com.crowdin.client.ai.model.AiPromptResponseList;
import com.crowdin.client.ai.model.AiPromptResponseObject;
import com.crowdin.client.ai.model.AiProvider;
import com.crowdin.client.ai.model.AiProviderModel;
import com.crowdin.client.ai.model.AiProviderModelResponseList;
import com.crowdin.client.ai.model.AiProviderRequest;
import com.crowdin.client.ai.model.AiProviderResponseList;
import com.crowdin.client.ai.model.AiProviderResponseObject;
import com.crowdin.client.ai.model.AiReportGenerate;
import com.crowdin.client.ai.model.AiReportGenerateResponse;
import com.crowdin.client.ai.model.AiSetting;
import com.crowdin.client.ai.model.AiSettingResponse;
import com.crowdin.client.ai.model.ChatCompletionResponseObject;
import com.crowdin.client.ai.model.CustomPlaceholder;
import com.crowdin.client.ai.model.CustomPlaceholderRequest;
import com.crowdin.client.ai.model.CustomPlaceholderResponseList;
import com.crowdin.client.ai.model.CustomPlaceholderResponseObject;
import com.crowdin.client.ai.model.FineTuningDatasetDownload;
import com.crowdin.client.ai.model.FineTuningDatasetDownloadResponse;
import com.crowdin.client.ai.model.FineTuningDatasetRequest;
import com.crowdin.client.ai.model.FineTuningDatasetResponse;
import com.crowdin.client.ai.model.FineTuningEvent;
import com.crowdin.client.ai.model.FineTuningEventResponseList;
import com.crowdin.client.ai.model.FineTuningJob;
import com.crowdin.client.ai.model.FineTuningJobRequest;
import com.crowdin.client.ai.model.FineTuningJobResponseList;
import com.crowdin.client.ai.model.FineTuningJobResponseObject;
import com.crowdin.client.ai.model.GenerateAiReportRequest;
import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.DownloadLinkResponseObject;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class AIApi
extends CrowdinApi {
    public AIApi(Credentials credentials) {
        super(credentials);
    }

    public AIApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<CustomPlaceholder> listCustomPlaceholders(Long userId, Integer limit, Integer offset) {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        String url = this.getAIPath(userId, "ai/settings/custom-placeholders");
        CustomPlaceholderResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(queryParams), CustomPlaceholderResponseList.class);
        return CustomPlaceholderResponseList.to(responseList);
    }

    public ResponseObject<CustomPlaceholder> addCustomPlaceholder(Long userId, CustomPlaceholderRequest request) {
        String url = this.getAIPath(userId, "ai/settings/custom-placeholders");
        CustomPlaceholderResponseObject response = this.httpClient.post(url, request, new HttpRequestConfig(), CustomPlaceholderResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<CustomPlaceholder> getCustomPlaceholder(Long userId, long aiCustomPlaceholderId) {
        String url = this.getAIPath(userId, "ai/settings/custom-placeholders/" + aiCustomPlaceholderId);
        CustomPlaceholderResponseObject response = this.httpClient.get(url, new HttpRequestConfig(), CustomPlaceholderResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteCustomPlaceholder(Long userId, long aiCustomPlaceholderId) {
        String url = this.getAIPath(userId, "ai/settings/custom-placeholders/" + aiCustomPlaceholderId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<CustomPlaceholder> editCustomPlaceholder(Long userId, long aiCustomPlaceholderId, List<PatchRequest> request) {
        String url = this.getAIPath(userId, "ai/settings/custom-placeholders/" + aiCustomPlaceholderId);
        CustomPlaceholderResponseObject response = this.httpClient.patch(url, request, new HttpRequestConfig(), CustomPlaceholderResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<FineTuningDatasetResponse.FineTuningDatasetData> getFineTuningDatasetGenerationStatus(Long userId, Long aiPromptId, String jobIdentifier) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/fine-tuning/datasets/" + jobIdentifier);
        FineTuningDatasetResponse response = this.httpClient.get(url, new HttpRequestConfig(), FineTuningDatasetResponse.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<FineTuningDatasetResponse.FineTuningDatasetData> generateFineTuningDataset(Long userId, Long aiPromptId, FineTuningDatasetRequest request) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/fine-tuning/datasets");
        FineTuningDatasetResponse response = this.httpClient.post(url, request, new HttpRequestConfig(), FineTuningDatasetResponse.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseList<FineTuningEvent> getFineTuningEventList(Long userId, Long aiPromptId, String jobIdentifier) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/fine-tuning/jobs/" + jobIdentifier + "/events");
        FineTuningEventResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(), FineTuningEventResponseList.class);
        return FineTuningEventResponseList.to(responseList);
    }

    public ResponseList<FineTuningJob> getFineTuningJobList(Long userId, Integer limit, Integer offset, String statuses, String orderBy) {
        Map<String, Optional<String>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset), "statuses", Optional.ofNullable(statuses), "orderBy", Optional.ofNullable(orderBy));
        String url = this.getAIPath(userId, "ai/prompts/fine-tuning/jobs");
        FineTuningJobResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(queryParams), FineTuningJobResponseList.class);
        return FineTuningJobResponseList.to(responseList);
    }

    public ResponseObject<FineTuningJob> createFineTuningJob(Long userId, Long aiPromptId, FineTuningJobRequest request) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/fine-tuning/jobs");
        FineTuningJobResponseObject responseObject = this.httpClient.post(url, request, new HttpRequestConfig(), FineTuningJobResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<FineTuningJob> getFineTuningJobStatus(Long userId, Long aiPromptId, String jobIdentifier) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/fine-tuning/jobs/" + jobIdentifier);
        FineTuningJobResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), FineTuningJobResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<FineTuningDatasetDownload> downloadFineTuningDataset(Long userId, long aiPromptId, String jobIdentifier) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/fine-tuning/datasets/" + jobIdentifier + "/download");
        FineTuningDatasetDownloadResponse response = this.httpClient.get(url, new HttpRequestConfig(), FineTuningDatasetDownloadResponse.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<AiPrompt> cloneAiPrompt(Long userId, long aiPromptId, AiPromptCloneRequest request) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/clones");
        AiPromptResponseObject response = this.httpClient.post(url, request, new HttpRequestConfig(), AiPromptResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseList<AiPrompt> listAiPrompts(Long userId, Long projectId, String action, Integer limit, Integer offset) {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("projectId", Optional.ofNullable(projectId), "action", Optional.ofNullable(action), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        String url = this.getAIPath(userId, "ai/prompts");
        AiPromptResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(queryParams), AiPromptResponseList.class);
        return AiPromptResponseList.to(responseList);
    }

    public ResponseObject<AiPrompt> addAiPrompt(Long userId, AiPromptAddRequest request) {
        String url = this.getAIPath(userId, "ai/prompts");
        AiPromptResponseObject response = this.httpClient.post(url, request, new HttpRequestConfig(), AiPromptResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<AiPromptCompletionResponse.AiPromptCompletionData> generatePromptCompletion(Long userId, long aiPromptId, AiPromptCompletionRequest request) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/completions");
        AiPromptCompletionResponse response = this.httpClient.post(url, request, new HttpRequestConfig(), AiPromptCompletionResponse.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<AiPromptCompletionResponse.AiPromptCompletionData> getPromptCompletionStatus(Long userId, long aiPromptId, String completionId) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/completions/" + completionId);
        AiPromptCompletionResponse response = this.httpClient.get(url, new HttpRequestConfig(), AiPromptCompletionResponse.class);
        return ResponseObject.of(response.getData());
    }

    public void cancelPromptCompletion(Long userId, long aiPromptId, String completionId) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/completions/" + completionId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<DownloadLink> downloadPromptCompletion(Long userId, long aiPromptId, String completionId) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId + "/completions/" + completionId + "/download");
        DownloadLinkResponseObject response = this.httpClient.get(url, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<AiPrompt> getAiPrompt(Long userId, long aiPromptId) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId);
        AiPromptResponseObject response = this.httpClient.get(url, new HttpRequestConfig(), AiPromptResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteAiPrompt(Long userId, long aiPromptId) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<AiPrompt> editAiPrompt(Long userId, long aiPromptId, List<PatchRequest> request) {
        String url = this.getAIPath(userId, "ai/prompts/" + aiPromptId);
        AiPromptResponseObject response = this.httpClient.patch(url, request, new HttpRequestConfig(), AiPromptResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<AiReportGenerate> generateAiReport(Long userId, GenerateAiReportRequest request) throws HttpException, HttpBadRequestException {
        String url = this.getAIPath(userId, "ai/reports");
        AiReportGenerateResponse response = this.httpClient.post(url, request, new HttpRequestConfig(), AiReportGenerateResponse.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<AiReportGenerate> checkAiReportGenerationStatus(Long userId, String aiReportId) throws HttpException, HttpBadRequestException {
        String url = this.getAIPath(userId, String.format("ai/reports/%s", aiReportId));
        AiReportGenerateResponse response = this.httpClient.get(url, new HttpRequestConfig(), AiReportGenerateResponse.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<DownloadLink> downloadAiReport(Long userId, String reportId) throws HttpException, HttpBadRequestException {
        String url = this.getAIPath(userId, String.format("ai/reports/%s/download", reportId));
        DownloadLinkResponseObject response = this.httpClient.get(url, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<AiSetting> getAiSetting(Long userId) {
        String url = this.getAIPath(userId, "ai/settings");
        AiSettingResponse aiSettingResponse = this.httpClient.get(url, new HttpRequestConfig(), AiSettingResponse.class);
        return ResponseObject.of(aiSettingResponse.getData());
    }

    public ResponseObject<AiSetting> editAiSetting(Long userId, List<PatchRequest> request) {
        String url = this.getAIPath(userId, "ai/settings");
        AiSettingResponse aiSettingResponse = this.httpClient.patch(url, request, new HttpRequestConfig(), AiSettingResponse.class);
        return ResponseObject.of(aiSettingResponse.getData());
    }

    public ResponseList<AiProvider> listAiProviders(Long userId, Integer limit, Integer offset) {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        String url = this.getAIPath(userId, "ai/providers");
        AiProviderResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(queryParams), AiProviderResponseList.class);
        return AiProviderResponseList.to(responseList);
    }

    public ResponseObject<AiProvider> addAiProviders(Long userId, AiProviderRequest request) {
        String url = this.getAIPath(userId, "ai/providers");
        AiProviderResponseObject response = this.httpClient.post(url, request, new HttpRequestConfig(), AiProviderResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<AiProvider> getAiProvider(Long userId, Long aiProviderId) {
        String url = this.getAIPath(userId, "ai/providers/" + aiProviderId);
        AiProviderResponseObject response = this.httpClient.get(url, new HttpRequestConfig(), AiProviderResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteAiProvider(Long userId, Long aiProviderId) {
        String url = this.getAIPath(userId, "ai/providers/" + aiProviderId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<AiProvider> editAiProvider(Long userId, Long aiProviderId, List<PatchRequest> requests) {
        String url = this.getAIPath(userId, "ai/providers/" + aiProviderId);
        AiProviderResponseObject response = this.httpClient.patch(url, requests, new HttpRequestConfig(), AiProviderResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseList<AiProviderModel> listAiProviderModels(Long userId, Long aiProviderId) {
        String url = this.getAIPath(userId, "ai/providers/" + aiProviderId + "/models");
        AiProviderModelResponseList responseList = this.httpClient.get(url, new HttpRequestConfig(), AiProviderModelResponseList.class);
        return AiProviderModelResponseList.to(responseList);
    }

    public ResponseObject<Map<String, Object>> createProxyChatCompletion(Long userId, Long aiProviderId, Map<String, Object> request) {
        String url = this.getAIPath(userId, "ai/providers/" + aiProviderId + "/chat/completions");
        ChatCompletionResponseObject response = this.httpClient.post(url, request, new HttpRequestConfig(), ChatCompletionResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    private String getAIPath(Long userId, String path) {
        return userId != null ? String.format("%s/users/%d/%s", this.url, userId, path) : String.format("%s/%s", this.url, path);
    }
}

