/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.applications;

import com.crowdin.client.applications.installations.model.ApplicationInstallation;
import com.crowdin.client.applications.installations.model.ApplicationInstallationResponseList;
import com.crowdin.client.applications.installations.model.ApplicationInstallationResponseObject;
import com.crowdin.client.applications.installations.model.InstallApplicationRequest;
import com.crowdin.client.applications.model.ApplicationDataResponseObject;
import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ApplicationsApi
extends CrowdinApi {
    public ApplicationsApi(Credentials credentials) {
        super(credentials);
    }

    public ApplicationsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseObject<Map<String, Object>> getApplicationData(String applicationIdentifier, String path) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/%s/api/%s", this.url, applicationIdentifier, path);
        ApplicationDataResponseObject response = this.httpClient.get(builtUrl, new HttpRequestConfig(), ApplicationDataResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<Map<String, Object>> updateOrRestoreApplicationData(String applicationIdentifier, String path, Map<String, Object> request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/%s/api/%s", this.url, applicationIdentifier, path);
        ApplicationDataResponseObject response = this.httpClient.put(builtUrl, request, new HttpRequestConfig(), ApplicationDataResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<Map<String, Object>> addApplicationData(String applicationIdentifier, String path, Map<String, Object> request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/%s/api/%s", this.url, applicationIdentifier, path);
        ApplicationDataResponseObject response = this.httpClient.post(builtUrl, request, new HttpRequestConfig(), ApplicationDataResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteApplicationData(String applicationIdentifier, String path) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/%s/api/%s", this.url, applicationIdentifier, path);
        this.httpClient.delete(builtUrl, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Map<String, Object>> editApplicationData(String applicationIdentifier, String path, Map<String, Object> request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/%s/api/%s", this.url, applicationIdentifier, path);
        ApplicationDataResponseObject response = this.httpClient.patch(builtUrl, request, new HttpRequestConfig(), ApplicationDataResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<ApplicationInstallation> getApplicationInstallation(String identifier) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/installations/%s", this.url, identifier);
        ApplicationInstallationResponseObject response = this.httpClient.get(builtUrl, new HttpRequestConfig(), ApplicationInstallationResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseList<ApplicationInstallation> listApplicationInstallations(Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/installations", this.url);
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        ApplicationInstallationResponseList response = this.httpClient.get(builtUrl, new HttpRequestConfig(queryParams), ApplicationInstallationResponseList.class);
        return ApplicationInstallationResponseList.to(response);
    }

    public ResponseObject<ApplicationInstallation> installApplication(InstallApplicationRequest request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/installations", this.url);
        ApplicationInstallationResponseObject response = this.httpClient.post(builtUrl, request, new HttpRequestConfig(), ApplicationInstallationResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteApplicationInstallation(String identifier) throws HttpException, HttpBadRequestException {
        this.deleteApplicationInstallation(identifier, null);
    }

    public void deleteApplicationInstallation(String identifier, Boolean force) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Boolean>> queryParams = HttpRequestConfig.buildUrlParams("force", Optional.ofNullable(force));
        String builtUrl = String.format("%s/applications/installations/%s", this.url, identifier);
        this.httpClient.delete(builtUrl, new HttpRequestConfig(queryParams), Void.class);
    }

    public ResponseObject<ApplicationInstallation> editApplicationInstallation(String identifier, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/applications/installations/%s", this.url, identifier);
        ApplicationInstallationResponseObject response = this.httpClient.patch(builtUrl, request, new HttpRequestConfig(), ApplicationInstallationResponseObject.class);
        return ResponseObject.of(response.getData());
    }
}

