/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.core.http.impl.http;

import com.crowdin.client.core.http.HttpClient;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.JsonTransformer;
import com.crowdin.client.core.http.exceptions.CrowdinApiException;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApacheHttpClient
implements HttpClient {
    private final Credentials credentials;
    private final JsonTransformer jsonTransformer;
    private final Map<String, ?> defaultHeaders;
    private ClientConfig.Host proxy;
    private ClientConfig.UsernamePasswordCredentials proxyCreds;
    private final CloseableHttpClient httpClient;

    public ApacheHttpClient(Credentials credentials, JsonTransformer jsonTransformer, Map<String, ?> defaultHeaders, CloseableHttpClient httpClient) {
        this.credentials = credentials;
        this.jsonTransformer = jsonTransformer;
        this.defaultHeaders = defaultHeaders;
        this.httpClient = httpClient;
    }

    public ApacheHttpClient(Credentials credentials, JsonTransformer jsonTransformer, Map<String, ?> defaultHeaders, final ClientConfig.Host proxy, final ClientConfig.UsernamePasswordCredentials proxyCreds, Integer timeoutMs) {
        this.credentials = credentials;
        this.jsonTransformer = jsonTransformer;
        this.defaultHeaders = defaultHeaders;
        this.proxy = proxy;
        this.proxyCreds = proxyCreds;
        RequestConfig.Builder requestConfig = RequestConfig.custom().setCookieSpec("standard");
        if (timeoutMs != null) {
            requestConfig.setConnectionRequestTimeout(timeoutMs);
            requestConfig.setConnectTimeout(timeoutMs);
            requestConfig.setSocketTimeout(timeoutMs);
        }
        this.httpClient = proxy != null ? HttpClientBuilder.create().setProxy(new HttpHost(proxy.getHost(), proxy.getPort())).setDefaultRequestConfig(requestConfig.build()).setDefaultCredentialsProvider(proxyCreds != null ? new BasicCredentialsProvider(){
            {
                this.setCredentials(new AuthScope(proxy.getHost(), proxy.getPort()), new UsernamePasswordCredentials(proxyCreds.getUsername(), proxyCreds.getPassword()));
            }
        } : new BasicCredentialsProvider()).build() : HttpClientBuilder.create().setDefaultRequestConfig(requestConfig.build()).build();
    }

    @Override
    public <T> T get(String url, HttpRequestConfig config, Class<T> clazz) throws HttpException, HttpBadRequestException {
        return this.request(url, null, config, clazz, "GET");
    }

    @Override
    public <T> T delete(String url, HttpRequestConfig config, Class<T> clazz) throws HttpException, HttpBadRequestException {
        return this.request(url, null, config, clazz, "DELETE");
    }

    @Override
    public <T> T head(String url, HttpRequestConfig config, Class<T> clazz) throws HttpException, HttpBadRequestException {
        return this.request(url, null, config, clazz, "HEAD");
    }

    @Override
    public <T, V> T post(String url, V data, HttpRequestConfig config, Class<T> clazz) throws HttpException, HttpBadRequestException {
        return this.request(url, data, config, clazz, "POST");
    }

    @Override
    public <T, V> T put(String url, V data, HttpRequestConfig config, Class<T> clazz) throws HttpException, HttpBadRequestException {
        return this.request(url, data, config, clazz, "PUT");
    }

    @Override
    public <T, V> T patch(String url, V data, HttpRequestConfig config, Class<T> clazz) throws HttpException, HttpBadRequestException {
        return this.request(url, data, config, clazz, "PATCH");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T, V> T request(String url, V data, HttpRequestConfig config, Class<T> clazz, String method) throws HttpException, HttpBadRequestException {
        HttpUriRequest request = this.buildRequest(method, url, data, config);
        String httpResponse = null;
        try (CloseableHttpResponse response = this.httpClient.execute(request);){
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode < 200 || statusCode >= 300) {
                String error = this.toString(response.getEntity());
                throw this.jsonTransformer.parse(error, CrowdinApiException.class);
            }
            if (String.class.equals(clazz)) {
                String string = this.toString(response.getEntity());
                return (T)string;
            }
            if (Void.class.equals(clazz)) {
                T t = null;
                return t;
            }
            httpResponse = this.toString(response.getEntity());
            T t = this.jsonTransformer.parse(httpResponse, clazz);
            return t;
        }
        catch (IOException e) {
            throw HttpException.fromMessage(e.getMessage(), httpResponse);
        }
    }

    private <V> HttpUriRequest buildRequest(String httpMethod, String url, V data, HttpRequestConfig config) {
        RequestBuilder requestBuilder = RequestBuilder.create(httpMethod);
        requestBuilder.setUri(URI.create(this.appendUrlParams(url, config.getUrlParams())));
        requestBuilder.addHeader("Authorization", "Bearer " + this.credentials.getToken());
        if (data != null) {
            AbstractHttpEntity entity = data instanceof InputStream ? new InputStreamEntity((InputStream)data) : (data instanceof String ? new StringEntity((String)data, ContentType.APPLICATION_OCTET_STREAM) : new StringEntity(this.jsonTransformer.convert(data), ContentType.APPLICATION_JSON));
            requestBuilder.setEntity(entity);
        } else if ("POST".equals(httpMethod)) {
            requestBuilder.setEntity(new StringEntity("", ContentType.APPLICATION_JSON));
        }
        HashMap headers = new HashMap();
        headers.putAll(config.getHeaders());
        headers.putAll(this.defaultHeaders);
        for (Map.Entry entry : headers.entrySet()) {
            requestBuilder = requestBuilder.addHeader((String)entry.getKey(), entry.getValue().toString());
        }
        return requestBuilder.build();
    }

    private String toString(HttpEntity entity) throws IOException {
        int charsRead;
        InputStream stream = entity.getContent();
        int bufferSize = 1024;
        char[] buffer = new char[1024];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(stream, StandardCharsets.UTF_8);
        while ((charsRead = ((Reader)in).read(buffer, 0, buffer.length)) > 0) {
            out.append(buffer, 0, charsRead);
        }
        return out.toString();
    }
}

