/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.distributions;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.Pagination;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.distributions.model.AddDistributionRequest;
import com.crowdin.client.distributions.model.AddDistributionStringsBasedRequest;
import com.crowdin.client.distributions.model.Distribution;
import com.crowdin.client.distributions.model.DistributionRelease;
import com.crowdin.client.distributions.model.DistributionReleaseResponseObject;
import com.crowdin.client.distributions.model.DistributionResponseList;
import com.crowdin.client.distributions.model.DistributionResponseObject;
import com.crowdin.client.distributions.model.DistributionStringsBasedRelease;
import com.crowdin.client.distributions.model.DistributionStringsBasedReleaseResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class DistributionsApi
extends CrowdinApi {
    public DistributionsApi(Credentials credentials) {
        super(credentials);
    }

    public DistributionsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Distribution> listDistributions(Long projectId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Pagination pagination = new Pagination();
        pagination.setLimit(limit);
        pagination.setOffset(offset);
        return this.listDistributions(projectId, pagination);
    }

    public ResponseList<Distribution> listDistributions(Long projectId, Pagination options) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        DistributionResponseList distributionResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/distributions", new HttpRequestConfig(queryParams), DistributionResponseList.class);
        return DistributionResponseList.to(distributionResponseList);
    }

    public ResponseObject<Distribution> addDistribution(Long projectId, AddDistributionRequest request) throws HttpException, HttpBadRequestException {
        DistributionResponseObject distributionResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/distributions", request, new HttpRequestConfig(), DistributionResponseObject.class);
        return ResponseObject.of(distributionResponseObject.getData());
    }

    public ResponseObject<Distribution> addDistributionStringsBased(Long projectId, AddDistributionStringsBasedRequest request) throws HttpException, HttpBadRequestException {
        DistributionResponseObject distributionResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/distributions", request, new HttpRequestConfig(), DistributionResponseObject.class);
        return ResponseObject.of(distributionResponseObject.getData());
    }

    public ResponseObject<Distribution> getDistribution(Long projectId, String hash) throws HttpException, HttpBadRequestException {
        DistributionResponseObject distributionResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/distributions/" + hash, new HttpRequestConfig(), DistributionResponseObject.class);
        return ResponseObject.of(distributionResponseObject.getData());
    }

    public void deleteDistribution(Long projectId, String hash) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/distributions/" + hash, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Distribution> editDistribution(Long projectId, String hash, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        DistributionResponseObject distributionResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/distributions/" + hash, request, new HttpRequestConfig(), DistributionResponseObject.class);
        return ResponseObject.of(distributionResponseObject.getData());
    }

    public ResponseObject<DistributionRelease> getDistributionRelease(Long projectId, String hash) throws HttpException, HttpBadRequestException {
        DistributionReleaseResponseObject distributionReleaseResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/distributions/" + hash + "/release", new HttpRequestConfig(), DistributionReleaseResponseObject.class);
        return ResponseObject.of(distributionReleaseResponseObject.getData());
    }

    public ResponseObject<DistributionStringsBasedRelease> getDistributionStringsBasedRelease(Long projectId, String hash) throws HttpException, HttpBadRequestException {
        DistributionStringsBasedReleaseResponseObject distributionReleaseResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/distributions/" + hash + "/release", new HttpRequestConfig(), DistributionStringsBasedReleaseResponseObject.class);
        return ResponseObject.of(distributionReleaseResponseObject.getData());
    }

    public ResponseObject<DistributionRelease> createDistributionRelease(Long projectId, String hash) throws HttpException, HttpBadRequestException {
        DistributionReleaseResponseObject distributionReleaseResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/distributions/" + hash + "/release", new DistributionRelease(), new HttpRequestConfig(), DistributionReleaseResponseObject.class);
        return ResponseObject.of(distributionReleaseResponseObject.getData());
    }

    public ResponseObject<DistributionStringsBasedRelease> createDistributionStringsBasedRelease(Long projectId, String hash) throws HttpException, HttpBadRequestException {
        DistributionStringsBasedReleaseResponseObject distributionReleaseResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/distributions/" + hash + "/release", new DistributionStringsBasedRelease(), new HttpRequestConfig(), DistributionStringsBasedReleaseResponseObject.class);
        return ResponseObject.of(distributionReleaseResponseObject.getData());
    }
}

