/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.fields;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.fields.model.Field;
import com.crowdin.client.fields.model.FieldRequest;
import com.crowdin.client.fields.model.FieldResponseObject;
import com.crowdin.client.fields.model.FieldResponseObjectList;
import com.crowdin.client.fields.model.ListFieldsParams;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class FieldsApi
extends CrowdinApi {
    public FieldsApi(Credentials credentials) {
        super(credentials);
    }

    public FieldsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Field> listFields(String entity, String search, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListFieldsParams params = new ListFieldsParams();
        params.setEntity(entity);
        params.setSearch(search);
        params.setLimit(limit);
        params.setOffset(offset);
        return this.listFields(params);
    }

    public ResponseList<Field> listFields(ListFieldsParams params) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("entity", Optional.ofNullable(params.getEntity()), "search", Optional.ofNullable(params.getSearch()), "limit", Optional.ofNullable(params.getLimit()), "type", Optional.ofNullable(params.getType()), "offset", Optional.ofNullable(params.getOffset()));
        FieldResponseObjectList responseObject = this.httpClient.get(this.url + "/fields", new HttpRequestConfig(queryParams), FieldResponseObjectList.class);
        return FieldResponseObjectList.to(responseObject);
    }

    public ResponseObject<Field> addField(FieldRequest request) throws HttpException, HttpBadRequestException {
        FieldResponseObject reportStatusResponseObject = this.httpClient.post(this.url + "/fields", request, new HttpRequestConfig(), FieldResponseObject.class);
        return ResponseObject.of(reportStatusResponseObject.getData());
    }

    public ResponseList<Field> getField(Long fieldId) throws HttpException, HttpBadRequestException {
        FieldResponseObjectList responseObject = this.httpClient.get(this.url + "/fields/" + fieldId, new HttpRequestConfig(), FieldResponseObjectList.class);
        return FieldResponseObjectList.to(responseObject);
    }

    public void deleteField(Long fieldId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/fields/" + fieldId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Field> editField(Long fieldId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        FieldResponseObject responseObject = this.httpClient.patch(this.url + "/fields/" + fieldId, request, new HttpRequestConfig(), FieldResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }
}

