/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.languages;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.languages.model.AddCustomLanguageRequest;
import com.crowdin.client.languages.model.Language;
import com.crowdin.client.languages.model.LanguageResponseList;
import com.crowdin.client.languages.model.LanguageResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class LanguagesApi
extends CrowdinApi {
    public LanguagesApi(Credentials credentials) {
        super(credentials);
    }

    public LanguagesApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Language> listSupportedLanguages(Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        LanguageResponseList languageResponseList = this.httpClient.get(this.url + "/languages", new HttpRequestConfig(queryParams), LanguageResponseList.class);
        return LanguageResponseList.to(languageResponseList);
    }

    public ResponseObject<Language> addCustomLanguage(AddCustomLanguageRequest request) throws HttpException, HttpBadRequestException {
        LanguageResponseObject projectResponseObject = this.httpClient.post(this.url + "/languages", request, new HttpRequestConfig(), LanguageResponseObject.class);
        return ResponseObject.of(projectResponseObject.getData());
    }

    public ResponseObject<Language> getLanguage(String languageId) throws HttpException, HttpBadRequestException {
        LanguageResponseObject languageResponseObject = this.httpClient.get(this.url + "/languages/" + languageId, new HttpRequestConfig(), LanguageResponseObject.class);
        return ResponseObject.of(languageResponseObject.getData());
    }

    public void deleteLanguage(String languageId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/languages/" + languageId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Language> editLanguage(String languageId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        LanguageResponseObject languageResponseObject = this.httpClient.patch(this.url + "/languages/" + languageId, request, new HttpRequestConfig(), LanguageResponseObject.class);
        return ResponseObject.of(languageResponseObject.getData());
    }
}

