/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.notifications;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.notifications.model.SendNotificationToAuthenticatedUserRequest;
import com.crowdin.client.notifications.model.SendNotificationToOrganizationMembersRequest;
import com.crowdin.client.notifications.model.SendNotificationToProjectMemberRequest;

public class NotificationsApi
extends CrowdinApi {
    public NotificationsApi(Credentials credentials) {
        super(credentials);
    }

    public NotificationsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public void sendNotificationToAuthenticatedUser(SendNotificationToAuthenticatedUserRequest request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/notify", this.url);
        this.httpClient.post(builtUrl, request, new HttpRequestConfig(), Void.class);
    }

    public void sendNotificationToProjectMembers(Long projectId, SendNotificationToProjectMemberRequest request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/notify", this.url, projectId);
        this.httpClient.post(builtUrl, request, new HttpRequestConfig(), Void.class);
    }

    public void sendNotificationToOrganizationMembers(SendNotificationToOrganizationMembersRequest request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/notify", this.url);
        this.httpClient.post(builtUrl, request, new HttpRequestConfig(), Void.class);
    }
}

