/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.reports;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.DownloadLinkResponseObject;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.reports.model.ExportReportRequest;
import com.crowdin.client.reports.model.GenerateGroupReportRequest;
import com.crowdin.client.reports.model.GenerateReportRequest;
import com.crowdin.client.reports.model.GroupReportStatus;
import com.crowdin.client.reports.model.GroupReportStatusResponseObject;
import com.crowdin.client.reports.model.ListOrganizationReportSettingsParams;
import com.crowdin.client.reports.model.OrganizationReportSettingsTemplateList;
import com.crowdin.client.reports.model.OrganizationReportSettingsTemplateResponseObject;
import com.crowdin.client.reports.model.ReportArchive;
import com.crowdin.client.reports.model.ReportArchiveList;
import com.crowdin.client.reports.model.ReportArchiveResponseObject;
import com.crowdin.client.reports.model.ReportSettingsTemplate;
import com.crowdin.client.reports.model.ReportSettingsTemplateList;
import com.crowdin.client.reports.model.ReportSettingsTemplateResponseObject;
import com.crowdin.client.reports.model.ReportStatus;
import com.crowdin.client.reports.model.ReportStatusResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ReportsApi
extends CrowdinApi {
    public ReportsApi(Credentials credentials) {
        super(credentials);
    }

    public ReportsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseObject<GroupReportStatus> generateGroupReport(Long groupId, GenerateGroupReportRequest request) throws HttpException, HttpBadRequestException {
        String url = this.url + "/groups/" + groupId + "/reports";
        GroupReportStatusResponseObject responseObject = this.httpClient.post(url, request, new HttpRequestConfig(), GroupReportStatusResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<GroupReportStatus> checkGroupReportGenerationStatus(Long groupId, String reportId) throws HttpException, HttpBadRequestException {
        String url = this.url + "/groups/" + groupId + "/reports/" + reportId;
        GroupReportStatusResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), GroupReportStatusResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadGroupReport(Long groupId, String reportId) throws HttpException, HttpBadRequestException {
        String url = this.url + "/groups/" + groupId + "/reports/" + reportId + "/download";
        DownloadLinkResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<GroupReportStatus> generateOrganizationReport(GenerateGroupReportRequest request) throws HttpException, HttpBadRequestException {
        String url = this.url + "/reports";
        GroupReportStatusResponseObject responseObject = this.httpClient.post(url, request, new HttpRequestConfig(), GroupReportStatusResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<GroupReportStatus> checkOrganizationReportGenerationStatus(String reportId) throws HttpException, HttpBadRequestException {
        String url = this.url + "/reports/" + reportId;
        GroupReportStatusResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), GroupReportStatusResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadOrganizationReport(String reportId) throws HttpException, HttpBadRequestException {
        String url = this.url + "/reports/" + reportId + "/download";
        DownloadLinkResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseList<ReportSettingsTemplate.OrganizationReportSettingsTemplate> listOrganizationReportSettingsTemplates(ListOrganizationReportSettingsParams params) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("projectId", Optional.ofNullable(params.getProjectId()), "groupId", Optional.ofNullable(params.getGroupId()), "limit", Optional.ofNullable(params.getLimit()), "offset", Optional.ofNullable(params.getOffset()));
        OrganizationReportSettingsTemplateList reportSettingsTemplateList = this.httpClient.get(this.url + "/reports/settings-templates", new HttpRequestConfig(queryParams), OrganizationReportSettingsTemplateList.class);
        return OrganizationReportSettingsTemplateList.to(reportSettingsTemplateList);
    }

    public ResponseObject<ReportSettingsTemplate.OrganizationReportSettingsTemplate> addOrganizationReportSettingsTemplate(ReportSettingsTemplate.OrganizationReportSettingsTemplate request) throws HttpException, HttpBadRequestException {
        OrganizationReportSettingsTemplateResponseObject responseObject = this.httpClient.post(this.url + "/reports/settings-templates", request, new HttpRequestConfig(), OrganizationReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<ReportSettingsTemplate.OrganizationReportSettingsTemplate> getOrganizationReportSettingsTemplate(Long reportSettingsTemplateId) throws HttpException, HttpBadRequestException {
        OrganizationReportSettingsTemplateResponseObject responseObject = this.httpClient.get(this.url + "/reports/settings-templates/" + reportSettingsTemplateId, new HttpRequestConfig(), OrganizationReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<ReportSettingsTemplate.OrganizationReportSettingsTemplate> editOrganizationReportSettingsTemplate(Long reportSettingsTemplateId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        OrganizationReportSettingsTemplateResponseObject responseObject = this.httpClient.patch(this.url + "/reports/settings-templates/" + reportSettingsTemplateId, request, new HttpRequestConfig(), OrganizationReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public void deleteOrganizationReportSettingsTemplate(Long reportSettingsTemplateId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/reports/settings-templates/" + reportSettingsTemplateId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<ReportStatus> generateReport(Long projectId, GenerateReportRequest request) throws HttpException, HttpBadRequestException {
        ReportStatusResponseObject reportStatusResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/reports", request, new HttpRequestConfig(), ReportStatusResponseObject.class);
        return ResponseObject.of(reportStatusResponseObject.getData());
    }

    public ResponseObject<ReportStatus> checkReportGenerationStatus(Long projectId, String reportId) throws HttpException, HttpBadRequestException {
        ReportStatusResponseObject reportStatusResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/reports/" + reportId, new HttpRequestConfig(), ReportStatusResponseObject.class);
        return ResponseObject.of(reportStatusResponseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadReport(Long projectId, String reportId) throws HttpException, HttpBadRequestException {
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/reports/" + reportId + "/download", new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }

    public ResponseList<ReportSettingsTemplate> listReportSettingsTemplate(Long projectId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        ReportSettingsTemplateList reportSettingsTemplateList = this.httpClient.get(this.url + "/projects/" + projectId + "/reports/settings-templates", new HttpRequestConfig(queryParams), ReportSettingsTemplateList.class);
        return ReportSettingsTemplateList.to(reportSettingsTemplateList);
    }

    public ResponseObject<ReportSettingsTemplate> addReportSettingsTemplate(Long projectId, ReportSettingsTemplate request) throws HttpException, HttpBadRequestException {
        ReportSettingsTemplateResponseObject responseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/reports/settings-templates", request, new HttpRequestConfig(), ReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<ReportSettingsTemplate> getReportSettingsTemplate(Long projectId, Long reportSettingsTemplateId) throws HttpException, HttpBadRequestException {
        ReportSettingsTemplateResponseObject responseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/reports/settings-templates/" + reportSettingsTemplateId, new HttpRequestConfig(), ReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<ReportSettingsTemplate> editReportSettingsTemplate(Long projectId, Long reportSettingsTemplateId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        ReportSettingsTemplateResponseObject responseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/reports/settings-templates/" + reportSettingsTemplateId, request, new HttpRequestConfig(), ReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public void deleteReportSettingsTemplate(Long projectId, Long reportSettingsTemplateId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/reports/settings-templates/" + reportSettingsTemplateId, new HttpRequestConfig(), Void.class);
    }

    public ResponseList<ReportSettingsTemplate> listUserReportSettingsTemplate(Long userId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        ReportSettingsTemplateList reportSettingsTemplateList = this.httpClient.get(this.url + "/users/" + userId + "/reports/settings-templates", new HttpRequestConfig(queryParams), ReportSettingsTemplateList.class);
        return ReportSettingsTemplateList.to(reportSettingsTemplateList);
    }

    public ResponseObject<ReportSettingsTemplate> addUserReportSettingsTemplate(Long userId, ReportSettingsTemplate request) throws HttpException, HttpBadRequestException {
        ReportSettingsTemplateResponseObject responseObject = this.httpClient.post(this.url + "/users/" + userId + "/reports/settings-templates", request, new HttpRequestConfig(), ReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<ReportSettingsTemplate> getUserReportSettingsTemplate(Long userId, Long reportSettingsTemplateId) throws HttpException, HttpBadRequestException {
        ReportSettingsTemplateResponseObject responseObject = this.httpClient.get(this.url + "/users/" + userId + "/reports/settings-templates/" + reportSettingsTemplateId, new HttpRequestConfig(), ReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<ReportSettingsTemplate> editUserReportSettingsTemplate(Long userId, Long reportSettingsTemplateId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        ReportSettingsTemplateResponseObject responseObject = this.httpClient.patch(this.url + "/users/" + userId + "/reports/settings-templates/" + reportSettingsTemplateId, request, new HttpRequestConfig(), ReportSettingsTemplateResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public void deleteUserReportSettingsTemplate(Long userId, Long reportSettingsTemplateId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/users/" + userId + "/reports/settings-templates/" + reportSettingsTemplateId, new HttpRequestConfig(), Void.class);
    }

    public ResponseList<ReportArchive> listReportArchives(Long userId, String scopeType, Long scopeId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        String url = this.getReportArchivesPath(userId, "reports/archives/");
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("scopeType", Optional.ofNullable(scopeType), "scopeId", Optional.ofNullable(scopeId), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        ReportArchiveList responseObject = this.httpClient.get(url, new HttpRequestConfig(queryParams), ReportArchiveList.class);
        return ReportArchiveList.to(responseObject);
    }

    public ResponseObject<ReportArchive> getReportArchive(Long userId, Long archiveId) throws HttpException, HttpBadRequestException {
        String url = this.getReportArchivesPath(userId, "reports/archives/" + archiveId);
        ReportArchiveResponseObject reportArchiveResponseObject = this.httpClient.get(url, new HttpRequestConfig(), ReportArchiveResponseObject.class);
        return ResponseObject.of(reportArchiveResponseObject.getData());
    }

    public void deleteReportArchive(Long userId, Long archiveId) throws HttpException, HttpBadRequestException {
        String url = this.getReportArchivesPath(userId, "reports/archives/" + archiveId);
        this.httpClient.delete(url, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<GroupReportStatus> exportReportArchive(Long userId, Long archiveId, ExportReportRequest request) throws HttpException, HttpBadRequestException {
        String url = this.getReportArchivesPath(userId, "reports/archives/" + archiveId + "/exports");
        GroupReportStatusResponseObject responseObject = this.httpClient.post(url, request, new HttpRequestConfig(), GroupReportStatusResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<GroupReportStatus> checkReportArchiveExportStatus(Long userId, Long archiveId, String exportId) throws HttpException, HttpBadRequestException {
        String url = this.getReportArchivesPath(userId, "reports/archives/" + archiveId + "/exports/" + exportId);
        GroupReportStatusResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), GroupReportStatusResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadReportArchive(Long userId, Long archiveId, String exportId) throws HttpException, HttpBadRequestException {
        String url = this.getReportArchivesPath(userId, "reports/archives" + archiveId + "/exports/" + exportId + "/download");
        DownloadLinkResponseObject responseObject = this.httpClient.get(url, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(responseObject.getData());
    }

    private String getReportArchivesPath(Long userId, String path) {
        return userId != null ? String.format("%s/users/%d/%s", this.url, userId, path) : String.format("%s/%s", this.url, path);
    }
}

