/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.securitylogs;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.securitylogs.model.SecurityLogResource;
import com.crowdin.client.securitylogs.model.SecurityLogResourceObject;
import com.crowdin.client.securitylogs.model.SecurityLogsResourceResponseList;
import java.util.Map;
import java.util.Optional;

public class SecurityLogsApi
extends CrowdinApi {
    public SecurityLogsApi(Credentials credentials) {
        super(credentials);
    }

    public SecurityLogsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<SecurityLogResource> listUserSecurityLogs(Long userId, Long limit, Integer offset, String event, String ipAddress) throws HttpException, HttpBadRequestException {
        Map<String, Optional<String>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset), "event", Optional.ofNullable(event), "ipAddress", Optional.ofNullable(ipAddress));
        SecurityLogsResourceResponseList securityLogsResponseList = this.httpClient.get(this.url + "/users/" + userId + "/security-logs", new HttpRequestConfig(queryParams), SecurityLogsResourceResponseList.class);
        return SecurityLogsResourceResponseList.to(securityLogsResponseList);
    }

    public ResponseObject<SecurityLogResource> getUserSecurityLog(Long userId, Long securityLogId) throws HttpException, HttpBadRequestException {
        SecurityLogResourceObject securityLogResourceObject = this.httpClient.get(this.url + "/users/" + userId + "/security-logs/" + securityLogId, new HttpRequestConfig(), SecurityLogResourceObject.class);
        return ResponseObject.of(securityLogResourceObject.getData());
    }

    public ResponseList<SecurityLogResource> listOrganizationSecurityLogs(Long limit, Integer offset, String event, String createdAfter, String createdBefore, String ipAddress, Long userId) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Long>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset), "event", Optional.ofNullable(event), "createdAfter", Optional.ofNullable(createdAfter), "createdBefore", Optional.ofNullable(createdBefore), "ipAddress", Optional.ofNullable(ipAddress), "userId", Optional.ofNullable(userId));
        SecurityLogsResourceResponseList securityLogsResponseList = this.httpClient.get(this.url + "/security-logs", new HttpRequestConfig(queryParams), SecurityLogsResourceResponseList.class);
        return SecurityLogsResourceResponseList.to(securityLogsResponseList);
    }

    public ResponseObject<SecurityLogResource> getOrganizationSecurityLog(Long securityLogId) throws HttpException, HttpBadRequestException {
        SecurityLogResourceObject securityLogResourceObject = this.httpClient.get(this.url + "/security-logs/" + securityLogId, new HttpRequestConfig(), SecurityLogResourceObject.class);
        return ResponseObject.of(securityLogResourceObject.getData());
    }
}

