/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.sourcefiles;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.DownloadLinkResponseObject;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.sourcefiles.model.AddBranchRequest;
import com.crowdin.client.sourcefiles.model.AddDirectoryRequest;
import com.crowdin.client.sourcefiles.model.AddFileRequest;
import com.crowdin.client.sourcefiles.model.Branch;
import com.crowdin.client.sourcefiles.model.BranchResponseList;
import com.crowdin.client.sourcefiles.model.BranchResponseObject;
import com.crowdin.client.sourcefiles.model.BuildReviewedSourceFilesRequest;
import com.crowdin.client.sourcefiles.model.Directory;
import com.crowdin.client.sourcefiles.model.DirectoryResponseList;
import com.crowdin.client.sourcefiles.model.DirectoryResponseObject;
import com.crowdin.client.sourcefiles.model.FileInfo;
import com.crowdin.client.sourcefiles.model.FileInfoResponseList;
import com.crowdin.client.sourcefiles.model.FileResponseObject;
import com.crowdin.client.sourcefiles.model.FileRevision;
import com.crowdin.client.sourcefiles.model.FileRevisionResponseList;
import com.crowdin.client.sourcefiles.model.FileRevisionResponseObject;
import com.crowdin.client.sourcefiles.model.ReviewedStringBuildResponseList;
import com.crowdin.client.sourcefiles.model.ReviewedStringBuildResponseObject;
import com.crowdin.client.sourcefiles.model.ReviewedStringsBuild;
import com.crowdin.client.sourcefiles.model.UpdateOrRestoreFileRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SourceFilesApi
extends CrowdinApi {
    public SourceFilesApi(Credentials credentials) {
        super(credentials);
    }

    public SourceFilesApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<Branch> listBranches(Long projectId, String name, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("name", Optional.ofNullable(name), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        BranchResponseList branchResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/branches", new HttpRequestConfig(queryParams), BranchResponseList.class);
        return BranchResponseList.to(branchResponseList);
    }

    public ResponseObject<Branch> addBranch(Long projectId, AddBranchRequest request) throws HttpException, HttpBadRequestException {
        BranchResponseObject branchResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/branches", request, new HttpRequestConfig(), BranchResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }

    public ResponseObject<Branch> getBranch(Long projectId, Long branchId) throws HttpException, HttpBadRequestException {
        BranchResponseObject branchResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/branches/" + branchId, new HttpRequestConfig(), BranchResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }

    public void deleteBranch(Long projectId, Long branchId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/branches/" + branchId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Branch> editBranch(Long projectId, Long branchId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        BranchResponseObject branchResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/branches/" + branchId, request, new HttpRequestConfig(), BranchResponseObject.class);
        return ResponseObject.of(branchResponseObject.getData());
    }

    public ResponseList<Directory> listDirectories(Long projectId, Long branchId, Long directoryId, String filter, Object recursion, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("branchId", Optional.ofNullable(branchId), "directoryId", Optional.ofNullable(directoryId), "filter", Optional.ofNullable(filter), "recursion", Optional.ofNullable(recursion), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        DirectoryResponseList directoryResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/directories", new HttpRequestConfig(queryParams), DirectoryResponseList.class);
        return DirectoryResponseList.to(directoryResponseList);
    }

    public ResponseObject<Directory> addDirectory(Long projectId, AddDirectoryRequest request) throws HttpException, HttpBadRequestException {
        DirectoryResponseObject post = this.httpClient.post(this.url + "/projects/" + projectId + "/directories", request, new HttpRequestConfig(), DirectoryResponseObject.class);
        return ResponseObject.of(post.getData());
    }

    public ResponseObject<Directory> getDirectory(Long projectId, Long directoryId) throws HttpException, HttpBadRequestException {
        DirectoryResponseObject directoryResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/directories/" + directoryId, new HttpRequestConfig(), DirectoryResponseObject.class);
        return ResponseObject.of(directoryResponseObject.getData());
    }

    public void deleteDirectory(Long projectId, Long directoryId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/directories/" + directoryId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<Directory> editDirectory(Long projectId, Long directoryId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        DirectoryResponseObject directoryResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/directories/" + directoryId, request, new HttpRequestConfig(), DirectoryResponseObject.class);
        return ResponseObject.of(directoryResponseObject.getData());
    }

    public ResponseList<? extends FileInfo> listFiles(Long projectId, Long branchId, Long directoryId, String filter, Object recursion, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("branchId", Optional.ofNullable(branchId), "directoryId", Optional.ofNullable(directoryId), "filter", Optional.ofNullable(filter), "recursion", Optional.ofNullable(recursion), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        FileInfoResponseList fileInfoResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/files", new HttpRequestConfig(queryParams), FileInfoResponseList.class);
        return FileInfoResponseList.to(fileInfoResponseList);
    }

    public ResponseObject<? extends FileInfo> addFile(Long projectId, AddFileRequest request) throws HttpException, HttpBadRequestException {
        FileResponseObject fileResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/files", request, new HttpRequestConfig(), FileResponseObject.class);
        return ResponseObject.of(fileResponseObject.getData());
    }

    public ResponseObject<? extends FileInfo> getFile(Long projectId, Long fileId) throws HttpException, HttpBadRequestException {
        FileResponseObject fileResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/files/" + fileId, new HttpRequestConfig(), FileResponseObject.class);
        return ResponseObject.of(fileResponseObject.getData());
    }

    public ResponseObject<? extends FileInfo> updateOrRestoreFile(Long projectId, Long fileId, UpdateOrRestoreFileRequest request) throws HttpException, HttpBadRequestException {
        FileResponseObject fileResponseObject = this.httpClient.put(this.url + "/projects/" + projectId + "/files/" + fileId, request, new HttpRequestConfig(), FileResponseObject.class);
        return ResponseObject.of(fileResponseObject.getData());
    }

    public void deleteFile(Long projectId, Long fileId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/files/" + fileId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<? extends FileInfo> editFile(Long projectId, Long fileId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        FileResponseObject fileResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/files/" + fileId, request, new HttpRequestConfig(), FileResponseObject.class);
        return ResponseObject.of(fileResponseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadFile(Long projectId, Long fileId) throws HttpException, HttpBadRequestException {
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/files/" + fileId + "/download", new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }

    public ResponseList<FileRevision> listFileRevisions(Long projectId, Long fileId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        FileRevisionResponseList fileRevisionResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/files/" + fileId + "/revisions", new HttpRequestConfig(queryParams), FileRevisionResponseList.class);
        return FileRevisionResponseList.to(fileRevisionResponseList);
    }

    public ResponseObject<FileRevision> getFileRevision(Long projectId, Long fileId, Long revisionId) throws HttpException, HttpBadRequestException {
        FileRevisionResponseObject fileResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/files/" + fileId + "/revisions/" + revisionId, new HttpRequestConfig(), FileRevisionResponseObject.class);
        return ResponseObject.of(fileResponseObject.getData());
    }

    public ResponseList<ReviewedStringsBuild> listReviewedSourceFilesBuilds(Long projectId, Long branchId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/strings/reviewed-builds", this.url, projectId);
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("branchId", Optional.ofNullable(branchId), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        ReviewedStringBuildResponseList reviewedStringBuildResponseList = this.httpClient.get(builtUrl, new HttpRequestConfig(queryParams), ReviewedStringBuildResponseList.class);
        return ReviewedStringBuildResponseList.to(reviewedStringBuildResponseList);
    }

    public ResponseObject<ReviewedStringsBuild> buildReviewedSourceFiles(Long projectId, BuildReviewedSourceFilesRequest request) {
        String builtUrl = String.format("%s/projects/%d/strings/reviewed-builds", this.url, projectId);
        ReviewedStringBuildResponseObject reviewedStringBuildResponseObject = this.httpClient.post(builtUrl, request, new HttpRequestConfig(), ReviewedStringBuildResponseObject.class);
        return ResponseObject.of(reviewedStringBuildResponseObject.getData());
    }

    public ResponseObject<ReviewedStringsBuild> checkReviewedSourceFilesBuildStatus(Long projectId, Long buildId) {
        String builtUrl = String.format("%s/projects/%d/strings/reviewed-builds/%d", this.url, projectId, buildId);
        ReviewedStringBuildResponseObject reviewedStringBuildResponseObject = this.httpClient.get(builtUrl, new HttpRequestConfig(), ReviewedStringBuildResponseObject.class);
        return ResponseObject.of(reviewedStringBuildResponseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadReviewedSourceFiles(Long projectId, Long buildId) {
        String builtUrl = String.format("%s/projects/%d/strings/reviewed-builds/%d/download", this.url, projectId, buildId);
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.get(builtUrl, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadFilePreview(Long projectId, Long fileId) throws HttpException, HttpBadRequestException {
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/files/" + fileId + "/preview", new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }
}

