/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.sourcestrings;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.sourcestrings.model.AddSourcePluralStringRequest;
import com.crowdin.client.sourcestrings.model.AddSourcePluralStringStringsBasedRequest;
import com.crowdin.client.sourcestrings.model.AddSourceStringRequest;
import com.crowdin.client.sourcestrings.model.AddSourceStringStringsBasedRequest;
import com.crowdin.client.sourcestrings.model.ListSourceStringsParams;
import com.crowdin.client.sourcestrings.model.SourceString;
import com.crowdin.client.sourcestrings.model.SourceStringResponseList;
import com.crowdin.client.sourcestrings.model.SourceStringResponseObject;
import com.crowdin.client.sourcestrings.model.UploadStringsProgress;
import com.crowdin.client.sourcestrings.model.UploadStringsProgressResponseObject;
import com.crowdin.client.sourcestrings.model.UploadStringsRequest;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class SourceStringsApi
extends CrowdinApi {
    public SourceStringsApi(Credentials credentials) {
        super(credentials);
    }

    public SourceStringsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseObject<UploadStringsProgress> uploadStringsStatus(Long projectId, String uploadId) throws HttpException, HttpBadRequestException {
        UploadStringsProgressResponseObject stringsProgressResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/strings/uploads/" + uploadId, new HttpRequestConfig(), UploadStringsProgressResponseObject.class);
        return ResponseObject.of(stringsProgressResponseObject.getData());
    }

    public ResponseObject<UploadStringsProgress> uploadStrings(Long projectId, UploadStringsRequest request) throws HttpException, HttpBadRequestException {
        UploadStringsProgressResponseObject stringsProgressResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/strings/uploads", request, new HttpRequestConfig(), UploadStringsProgressResponseObject.class);
        return ResponseObject.of(stringsProgressResponseObject.getData());
    }

    @Deprecated
    public ResponseList<SourceString> listSourceStrings(Long projectId, Long fileId, Integer denormalizePlaceholders, Long branchId, String labelIds, String croql, String filter, String scope, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListSourceStringsParams params = ListSourceStringsParams.builder().fileId(fileId).denormalizePlaceholders(denormalizePlaceholders).branchId(branchId).labelIds(labelIds).croql(croql).filter(filter).scope(scope).limit(limit).offset(offset).build();
        return this.listSourceStrings(projectId, params);
    }

    public ResponseList<SourceString> listSourceStrings(Long projectId, ListSourceStringsParams params) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("orderBy", Optional.ofNullable(params.getOrderBy()), "denormalizePlaceholders", Optional.ofNullable(params.getDenormalizePlaceholders()), "labelIds", Optional.ofNullable(params.getLabelIds()), "fileId", Optional.ofNullable(params.getFileId()), "branchId", Optional.ofNullable(params.getBranchId()), "directoryId", Optional.ofNullable(params.getDirectoryId()), "taskId", Optional.ofNullable(params.getTaskId()), "croql", Optional.ofNullable(params.getCroql()), "filter", Optional.ofNullable(params.getFilter()), "scope", Optional.ofNullable(params.getScope()), "limit", Optional.ofNullable(params.getLimit()), "offset", Optional.ofNullable(params.getOffset()));
        SourceStringResponseList sourceStringResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/strings", new HttpRequestConfig(queryParams), SourceStringResponseList.class);
        return SourceStringResponseList.to(sourceStringResponseList);
    }

    public ResponseObject<SourceString> addSourceString(Long projectId, AddSourceStringRequest request) throws HttpException, HttpBadRequestException {
        SourceStringResponseObject sourceStringResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/strings", request, new HttpRequestConfig(), SourceStringResponseObject.class);
        return ResponseObject.of(sourceStringResponseObject.getData());
    }

    public ResponseObject<SourceString> addSourcePluralString(Long projectId, AddSourcePluralStringRequest request) throws HttpException, HttpBadRequestException {
        SourceStringResponseObject sourceStringResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/strings", request, new HttpRequestConfig(), SourceStringResponseObject.class);
        return ResponseObject.of(sourceStringResponseObject.getData());
    }

    public ResponseObject<SourceString> addSourceStringStringsBased(Long projectId, AddSourceStringStringsBasedRequest request) throws HttpException, HttpBadRequestException {
        SourceStringResponseObject sourceStringResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/strings", request, new HttpRequestConfig(), SourceStringResponseObject.class);
        return ResponseObject.of(sourceStringResponseObject.getData());
    }

    public ResponseObject<SourceString> addSourcePluralStringStringsBased(Long projectId, AddSourcePluralStringStringsBasedRequest request) throws HttpException, HttpBadRequestException {
        SourceStringResponseObject sourceStringResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/strings", request, new HttpRequestConfig(), SourceStringResponseObject.class);
        return ResponseObject.of(sourceStringResponseObject.getData());
    }

    public ResponseObject<SourceString> getSourceString(Long projectId, Long stringId) throws HttpException, HttpBadRequestException {
        SourceStringResponseObject sourceStringResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/strings/" + stringId, new HttpRequestConfig(), SourceStringResponseObject.class);
        return ResponseObject.of(sourceStringResponseObject.getData());
    }

    public void deleteSourceString(Long projectId, Long stringId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/strings/" + stringId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<SourceString> editSourceString(Long projectId, Long stringId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        SourceStringResponseObject sourceStringResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/strings/" + stringId, request, new HttpRequestConfig(), SourceStringResponseObject.class);
        return ResponseObject.of(sourceStringResponseObject.getData());
    }

    public ResponseList<SourceString> stringBatchOperations(Long projectId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        String url = this.url + "/projects/" + projectId + "/strings";
        SourceStringResponseList sourceStringResponseList = this.httpClient.patch(url, request, new HttpRequestConfig(), SourceStringResponseList.class);
        return SourceStringResponseList.to(sourceStringResponseList);
    }
}

