/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.stringtranslations;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.BooleanInt;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.stringtranslations.model.AddApprovalRequest;
import com.crowdin.client.stringtranslations.model.AddStringTranslationRequest;
import com.crowdin.client.stringtranslations.model.AddVoteRequest;
import com.crowdin.client.stringtranslations.model.AlignTranslationRequest;
import com.crowdin.client.stringtranslations.model.AlignTranslationResponse;
import com.crowdin.client.stringtranslations.model.Approval;
import com.crowdin.client.stringtranslations.model.ApprovalResponseList;
import com.crowdin.client.stringtranslations.model.ApprovalResponseObject;
import com.crowdin.client.stringtranslations.model.LanguageTranslations;
import com.crowdin.client.stringtranslations.model.LanguageTranslationsResponseList;
import com.crowdin.client.stringtranslations.model.ListLanguageTranslationsOptions;
import com.crowdin.client.stringtranslations.model.ListStringTranslationsOptions;
import com.crowdin.client.stringtranslations.model.ListTranslationApprovalsOptions;
import com.crowdin.client.stringtranslations.model.ListTranslationVotesOptions;
import com.crowdin.client.stringtranslations.model.StringTranslation;
import com.crowdin.client.stringtranslations.model.StringTranslationResponseList;
import com.crowdin.client.stringtranslations.model.StringTranslationResponseObject;
import com.crowdin.client.stringtranslations.model.Vote;
import com.crowdin.client.stringtranslations.model.VoteResponseList;
import com.crowdin.client.stringtranslations.model.VoteResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class StringTranslationsApi
extends CrowdinApi {
    public StringTranslationsApi(Credentials credentials) {
        super(credentials);
    }

    public StringTranslationsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public AlignTranslationResponse alignTranslation(Long projectId, AlignTranslationRequest request) {
        String url = this.url + "/projects/" + projectId + "/translations/alignment";
        return this.httpClient.post(url, request, new HttpRequestConfig(), AlignTranslationResponse.class);
    }

    public ResponseList<Approval> listTranslationApprovals(Long projectId, Long fileId, Long stringId, String languageId, Long translationId, String labelIds, String excludeLabelIds, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListTranslationApprovalsOptions options = new ListTranslationApprovalsOptions();
        options.setFileId(fileId);
        options.setStringId(stringId);
        options.setLanguageId(languageId);
        options.setTranslationId(translationId);
        options.setLabelIds(labelIds);
        options.setExcludeLabelIds(excludeLabelIds);
        options.setLimit(limit);
        options.setOffset(offset);
        return this.listTranslationApprovals(projectId, options);
    }

    public ResponseList<Approval> listTranslationApprovals(Long projectId, ListTranslationApprovalsOptions options) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("orderBy", Optional.ofNullable(options.getOrderBy()), "fileId", Optional.ofNullable(options.getFileId()), "labelIds", Optional.ofNullable(options.getLabelIds()), "excludeLabelIds", Optional.ofNullable(options.getExcludeLabelIds()), "stringId", Optional.ofNullable(options.getStringId()), "languageId", Optional.ofNullable(options.getLanguageId()), "translationId", Optional.ofNullable(options.getTranslationId()), "limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        ApprovalResponseList approvalResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/approvals", new HttpRequestConfig(queryParams), ApprovalResponseList.class);
        return ApprovalResponseList.to(approvalResponseList);
    }

    public ResponseObject<Approval> addApproval(Long projectId, AddApprovalRequest request) throws HttpException, HttpBadRequestException {
        ApprovalResponseObject approvalResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/approvals", request, new HttpRequestConfig(), ApprovalResponseObject.class);
        return ResponseObject.of(approvalResponseObject.getData());
    }

    public ResponseObject<Approval> getApproval(Long projectId, Long approvalId) throws HttpException, HttpBadRequestException {
        ApprovalResponseObject storageResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/approvals/" + approvalId, new HttpRequestConfig(), ApprovalResponseObject.class);
        return ResponseObject.of(storageResponseObject.getData());
    }

    public void removeStringApprovals(Long projectId, Long stringId) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Long>> queryParams = HttpRequestConfig.buildUrlParams("stringId", Optional.of(stringId));
        this.httpClient.delete(this.url + "/projects/" + projectId + "/approvals", new HttpRequestConfig(queryParams), Void.class);
    }

    public void removeApproval(Long projectId, Long approvalId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/approvals/" + approvalId, new HttpRequestConfig(), Void.class);
    }

    public ResponseList<Approval> approvalBatchOperations(Long projectId, List<PatchRequest> request) {
        String url = this.url + "/projects/" + projectId + "/approvals";
        ApprovalResponseList response = this.httpClient.patch(url, request, new HttpRequestConfig(), ApprovalResponseList.class);
        return ApprovalResponseList.to(response);
    }

    public ResponseList<StringTranslation> translationBatchOperations(Long projectId, List<PatchRequest> request) {
        String url = this.url + "/projects/" + projectId + "/translations";
        StringTranslationResponseList response = this.httpClient.patch(url, request, new HttpRequestConfig(), StringTranslationResponseList.class);
        return StringTranslationResponseList.to(response);
    }

    public ResponseList<LanguageTranslations> listLanguageTranslations(Long projectId, String languageId, String stringIds, String labelIds, Long fileId, Long branchId, Long directoryId, String croql, Integer denormalizePlaceholders, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListLanguageTranslationsOptions options = new ListLanguageTranslationsOptions();
        options.setStringIds(stringIds);
        options.setLabelIds(labelIds);
        options.setFileId(fileId);
        options.setBranchId(branchId);
        options.setDirectoryId(directoryId);
        options.setCroql(croql);
        options.setDenormalizePlaceholders(BooleanInt.fromInt(denormalizePlaceholders));
        options.setLimit(limit);
        options.setOffset(offset);
        return this.listLanguageTranslations(projectId, languageId, options);
    }

    public ResponseList<LanguageTranslations> listLanguageTranslations(Long projectId, String languageId, ListLanguageTranslationsOptions options) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/languages/%s/translations", this.url, projectId, languageId);
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("stringIds", Optional.ofNullable(options.getStringIds()), "labelIds", Optional.ofNullable(options.getLabelIds()), "fileId", Optional.ofNullable(options.getFileId()), "branchId", Optional.ofNullable(options.getBranchId()), "directoryId", Optional.ofNullable(options.getDirectoryId()), "passedWorkflow", Optional.ofNullable(options.getPassedWorkflow()), "minApprovalCount", Optional.ofNullable(options.getMinApprovalCount()), "croql", Optional.ofNullable(options.getCroql()), "denormalizePlaceholders", Optional.ofNullable(options.getDenormalizePlaceholders()), "limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        LanguageTranslationsResponseList languageTranslationsResponseList = this.httpClient.get(builtUrl, new HttpRequestConfig(queryParams), LanguageTranslationsResponseList.class);
        return LanguageTranslationsResponseList.to(languageTranslationsResponseList);
    }

    public ResponseList<StringTranslation> listStringTranslations(Long projectId, Long stringId, String languageId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListStringTranslationsOptions options = new ListStringTranslationsOptions();
        options.setStringId(stringId);
        options.setLanguageId(languageId);
        options.setLimit(limit);
        options.setOffset(offset);
        return this.listStringTranslations(projectId, options);
    }

    public ResponseList<StringTranslation> listStringTranslations(Long projectId, ListStringTranslationsOptions options) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("stringId", Optional.ofNullable(options.getStringId()), "languageId", Optional.ofNullable(options.getLanguageId()), "orderBy", Optional.ofNullable(options.getOrderBy()), "denormalizePlaceholders", Optional.ofNullable(options.getDenormalizePlaceholders()), "limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        StringTranslationResponseList stringTranslationResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/translations", new HttpRequestConfig(queryParams), StringTranslationResponseList.class);
        return StringTranslationResponseList.to(stringTranslationResponseList);
    }

    public ResponseObject<StringTranslation> addTranslation(Long projectId, AddStringTranslationRequest request) throws HttpException, HttpBadRequestException {
        StringTranslationResponseObject stringTranslationResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/translations", request, new HttpRequestConfig(), StringTranslationResponseObject.class);
        return ResponseObject.of(stringTranslationResponseObject.getData());
    }

    public void deleteStringTranslations(Long projectId, Long stringId, String languageId) throws HttpException, HttpBadRequestException {
        Map<String, Optional<String>> queryParams = HttpRequestConfig.buildUrlParams("stringId", Optional.of(stringId), "languageId", Optional.ofNullable(languageId));
        this.httpClient.delete(this.url + "/projects/" + projectId + "/translations", new HttpRequestConfig(queryParams), Void.class);
    }

    public ResponseObject<StringTranslation> getStringTranslation(Long projectId, Long translationId) throws HttpException, HttpBadRequestException {
        StringTranslationResponseObject stringTranslationResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/translations/" + translationId, new HttpRequestConfig(), StringTranslationResponseObject.class);
        return ResponseObject.of(stringTranslationResponseObject.getData());
    }

    public void deleteStringTranslation(Long projectId, Long translationId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/translations/" + translationId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<StringTranslation> restoreStringTranslation(Long projectId, Long translationId) throws HttpException, HttpBadRequestException {
        StringTranslationResponseObject stringTranslationResponseObject = this.httpClient.put(this.url + "/projects/" + projectId + "/translations/" + translationId, null, new HttpRequestConfig(), StringTranslationResponseObject.class);
        return ResponseObject.of(stringTranslationResponseObject.getData());
    }

    public ResponseList<Vote> listTranslationVotes(Long projectId, Long stringId, String languageId, Long translationId, String labelIds, String excludeLabelIds, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        ListTranslationVotesOptions options = new ListTranslationVotesOptions();
        options.setStringId(stringId);
        options.setLanguageId(languageId);
        options.setTranslationId(translationId);
        options.setLabelIds(labelIds);
        options.setExcludeLabelIds(excludeLabelIds);
        options.setLimit(limit);
        options.setOffset(offset);
        return this.listTranslationVotes(projectId, options);
    }

    public ResponseList<Vote> listTranslationVotes(Long projectId, ListTranslationVotesOptions options) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("stringId", Optional.ofNullable(options.getStringId()), "languageId", Optional.ofNullable(options.getLanguageId()), "translationId", Optional.ofNullable(options.getTranslationId()), "fileId", Optional.ofNullable(options.getFileId()), "labelIds", Optional.ofNullable(options.getLabelIds()), "excludeLabelIds", Optional.ofNullable(options.getExcludeLabelIds()), "limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        VoteResponseList voteResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/votes", new HttpRequestConfig(queryParams), VoteResponseList.class);
        return VoteResponseList.to(voteResponseList);
    }

    public ResponseObject<Vote> addVote(Long projectId, AddVoteRequest request) throws HttpException, HttpBadRequestException {
        VoteResponseObject voteResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/votes", request, new HttpRequestConfig(), VoteResponseObject.class);
        return ResponseObject.of(voteResponseObject.getData());
    }

    public ResponseObject<Vote> getVote(Long projectId, Long voteId) throws HttpException, HttpBadRequestException {
        VoteResponseObject voteResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/votes/" + voteId, new HttpRequestConfig(), VoteResponseObject.class);
        return ResponseObject.of(voteResponseObject.getData());
    }

    public void cancelVote(Long projectId, Long voteId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/votes/" + voteId, new HttpRequestConfig(), Void.class);
    }
}

