/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.translations;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.DownloadLink;
import com.crowdin.client.core.model.DownloadLinkResponseObject;
import com.crowdin.client.core.model.Pagination;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.translations.model.ApplyPreTranslationRequest;
import com.crowdin.client.translations.model.ApplyPreTranslationStringsBasedRequest;
import com.crowdin.client.translations.model.BuildProjectDirectoryTranslationRequest;
import com.crowdin.client.translations.model.BuildProjectFileTranslationRequest;
import com.crowdin.client.translations.model.BuildProjectTranslationRequest;
import com.crowdin.client.translations.model.ExportProjectTranslationRequest;
import com.crowdin.client.translations.model.PreTranslation;
import com.crowdin.client.translations.model.PreTranslationReportResponse;
import com.crowdin.client.translations.model.PreTranslationReportResponseObject;
import com.crowdin.client.translations.model.PreTranslationResponseList;
import com.crowdin.client.translations.model.PreTranslationResponseObject;
import com.crowdin.client.translations.model.PreTranslationStatus;
import com.crowdin.client.translations.model.PreTranslationStatusResponseObject;
import com.crowdin.client.translations.model.ProjectBuild;
import com.crowdin.client.translations.model.ProjectBuildResponseList;
import com.crowdin.client.translations.model.ProjectBuildResponseObject;
import com.crowdin.client.translations.model.UploadTranslationsRequest;
import com.crowdin.client.translations.model.UploadTranslationsResponse;
import com.crowdin.client.translations.model.UploadTranslationsResponseObject;
import com.crowdin.client.translations.model.UploadTranslationsStringsRequest;
import com.crowdin.client.translations.model.UploadTranslationsStringsResponse;
import com.crowdin.client.translations.model.UploadTranslationsStringsResponseObject;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class TranslationsApi
extends CrowdinApi {
    public TranslationsApi(Credentials credentials) {
        super(credentials);
    }

    public TranslationsApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseObject<PreTranslationStatus> applyPreTranslation(Long projectId, ApplyPreTranslationRequest request) throws HttpException, HttpBadRequestException {
        PreTranslationStatusResponseObject preTranslationStatusResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/pre-translations", request, new HttpRequestConfig(), PreTranslationStatusResponseObject.class);
        return ResponseObject.of(preTranslationStatusResponseObject.getData());
    }

    public ResponseObject<PreTranslationStatus> applyPreTranslationStringsBased(Long projectId, ApplyPreTranslationStringsBasedRequest request) throws HttpException, HttpBadRequestException {
        PreTranslationStatusResponseObject preTranslationStatusResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/pre-translations", request, new HttpRequestConfig(), PreTranslationStatusResponseObject.class);
        return ResponseObject.of(preTranslationStatusResponseObject.getData());
    }

    public ResponseObject<PreTranslationStatus> preTranslationStatus(Long projectId, String preTranslationId) throws HttpException, HttpBadRequestException {
        PreTranslationStatusResponseObject preTranslationStatusResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/pre-translations/" + preTranslationId, new HttpRequestConfig(), PreTranslationStatusResponseObject.class);
        return ResponseObject.of(preTranslationStatusResponseObject.getData());
    }

    public ResponseObject<DownloadLink> buildProjectDirectoryTranslation(Long projectId, Long directoryId, BuildProjectDirectoryTranslationRequest request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/translations/builds/directories/%d", this.url, projectId, directoryId);
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.post(builtUrl, request, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }

    public ResponseObject<DownloadLink> buildProjectFileTranslation(Long projectId, Long fileId, String etag, BuildProjectFileTranslationRequest request) throws HttpException, HttpBadRequestException {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (etag != null) {
            headers.put("If-None-Match", etag);
        }
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/translations/builds/files/" + fileId, request, new HttpRequestConfig(Collections.emptyMap(), headers), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }

    public ResponseList<ProjectBuild> listProjectBuilds(Long projectId, Long branchId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("branchId", Optional.ofNullable(branchId), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        ProjectBuildResponseList projectBuildResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/translations/builds", new HttpRequestConfig(queryParams), ProjectBuildResponseList.class);
        return ProjectBuildResponseList.to(projectBuildResponseList);
    }

    public ResponseObject<ProjectBuild> buildProjectTranslation(Long projectId, BuildProjectTranslationRequest request) throws HttpException, HttpBadRequestException {
        ProjectBuildResponseObject projectBuildResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/translations/builds", request, new HttpRequestConfig(), ProjectBuildResponseObject.class);
        return ResponseObject.of(projectBuildResponseObject.getData());
    }

    public ResponseObject<UploadTranslationsResponse> uploadTranslations(Long projectId, String languageId, UploadTranslationsRequest request) throws HttpException, HttpBadRequestException {
        UploadTranslationsResponseObject projectBuildResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/translations/" + languageId, request, new HttpRequestConfig(), UploadTranslationsResponseObject.class);
        return ResponseObject.of(projectBuildResponseObject.getData());
    }

    public ResponseObject<UploadTranslationsStringsResponse> uploadTranslationStringsBased(Long projectId, String languageId, UploadTranslationsStringsRequest request) throws HttpException, HttpBadRequestException {
        UploadTranslationsStringsResponseObject projectBuildResponseObject = this.httpClient.post(this.url + "/projects/" + projectId + "/translations/" + languageId, request, new HttpRequestConfig(), UploadTranslationsStringsResponseObject.class);
        return ResponseObject.of(projectBuildResponseObject.getData());
    }

    public ResponseObject<DownloadLink> downloadProjectTranslations(Long projectId, Long buildId) throws HttpException, HttpBadRequestException {
        DownloadLinkResponseObject downloadLinkResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/translations/builds/" + buildId + "/download", new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(downloadLinkResponseObject.getData());
    }

    public ResponseObject<ProjectBuild> checkBuildStatus(Long projectId, Long buildId) throws HttpException, HttpBadRequestException {
        ProjectBuildResponseObject projectBuildResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/translations/builds/" + buildId, new HttpRequestConfig(), ProjectBuildResponseObject.class);
        return ResponseObject.of(projectBuildResponseObject.getData());
    }

    public void cancelBuild(Long projectId, Long buildId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/projects/" + projectId + "/translations/builds/" + buildId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<DownloadLink> exportProjectTranslation(Long projectId, ExportProjectTranslationRequest request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/translations/exports", this.url, projectId);
        DownloadLinkResponseObject response = this.httpClient.post(builtUrl, request, new HttpRequestConfig(), DownloadLinkResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseList<PreTranslation> listPreTranslations(Long projectId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Pagination pagination = new Pagination();
        pagination.setLimit(limit);
        pagination.setOffset(offset);
        return this.listPreTranslations(projectId, pagination);
    }

    public ResponseList<PreTranslation> listPreTranslations(Long projectId, Pagination options) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("limit", Optional.ofNullable(options.getLimit()), "offset", Optional.ofNullable(options.getOffset()));
        PreTranslationResponseList preTranslationResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/pre-translations", new HttpRequestConfig(queryParams), PreTranslationResponseList.class);
        return PreTranslationResponseList.to(preTranslationResponseList);
    }

    public ResponseObject<PreTranslation> editPreTranslation(Long projectId, String preTranslationId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        PreTranslationResponseObject preTranslationResponseObject = this.httpClient.patch(this.url + "/projects/" + projectId + "/pre-translations/" + preTranslationId, request, new HttpRequestConfig(), PreTranslationResponseObject.class);
        return ResponseObject.of(preTranslationResponseObject.getData());
    }

    public ResponseObject<PreTranslationReportResponse> getPreTranslationReport(Long projectId, String preTranslationId) throws HttpException, HttpBadRequestException {
        PreTranslationReportResponseObject response = this.httpClient.get(this.url + "/projects/" + projectId + "/pre-translations/" + preTranslationId + "/report", new HttpRequestConfig(), PreTranslationReportResponseObject.class);
        return ResponseObject.of(response.getData());
    }
}

