/*
 * Decompiled with CFR 0.152.
 */
package com.crowdin.client.users;

import com.crowdin.client.core.CrowdinApi;
import com.crowdin.client.core.http.HttpRequestConfig;
import com.crowdin.client.core.http.exceptions.HttpBadRequestException;
import com.crowdin.client.core.http.exceptions.HttpException;
import com.crowdin.client.core.model.ClientConfig;
import com.crowdin.client.core.model.Credentials;
import com.crowdin.client.core.model.PatchRequest;
import com.crowdin.client.core.model.ResponseList;
import com.crowdin.client.core.model.ResponseObject;
import com.crowdin.client.users.model.AddProjectMemberRequest;
import com.crowdin.client.users.model.GroupManager;
import com.crowdin.client.users.model.GroupManagerResponseList;
import com.crowdin.client.users.model.GroupManagerResponseObject;
import com.crowdin.client.users.model.InviteUserRequest;
import com.crowdin.client.users.model.ProjectMember;
import com.crowdin.client.users.model.ProjectMemberResponseList;
import com.crowdin.client.users.model.ProjectMemberResponseObject;
import com.crowdin.client.users.model.ProjectMembersResponse;
import com.crowdin.client.users.model.ReplaceProjectMemberPermissionsRequest;
import com.crowdin.client.users.model.Status;
import com.crowdin.client.users.model.TeamMember;
import com.crowdin.client.users.model.TeamMemberResponseList;
import com.crowdin.client.users.model.TeamMemberResponseObject;
import com.crowdin.client.users.model.TwoFactor;
import com.crowdin.client.users.model.User;
import com.crowdin.client.users.model.UserResponseList;
import com.crowdin.client.users.model.UserResponseObject;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class UsersApi
extends CrowdinApi {
    public UsersApi(Credentials credentials) {
        super(credentials);
    }

    public UsersApi(Credentials credentials, ClientConfig clientConfig) {
        super(credentials, clientConfig);
    }

    public ResponseList<GroupManager> listGroupManagers(Long groupId, List<Long> teamIds, String orderBy) throws HttpException, HttpBadRequestException {
        Map<String, Optional<String>> queryParams = HttpRequestConfig.buildUrlParams("teamIds", Optional.ofNullable(teamIds), "orderBy", Optional.ofNullable(orderBy));
        GroupManagerResponseList response = this.httpClient.get(this.url + "/groups/" + groupId + "/managers", new HttpRequestConfig(queryParams), GroupManagerResponseList.class);
        return GroupManagerResponseList.to(response);
    }

    public ResponseList<GroupManager> updateGroupManagers(Long groupId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        GroupManagerResponseList response = this.httpClient.patch(this.url + "/groups/" + groupId + "/managers", request, new HttpRequestConfig(), GroupManagerResponseList.class);
        return GroupManagerResponseList.to(response);
    }

    public ResponseObject<GroupManager> getGroupManager(Long groupId, Long userId) throws HttpException, HttpBadRequestException {
        GroupManagerResponseObject response = this.httpClient.get(this.url + "/groups/" + groupId + "/managers/" + userId, new HttpRequestConfig(), GroupManagerResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseList<ProjectMember> listProjectMembersEnterprise(Long projectId, String search, String languageId, Long workflowStepId, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/members", this.url, projectId);
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("search", Optional.ofNullable(search), "languageId", Optional.ofNullable(languageId), "workflowStepId", Optional.ofNullable(workflowStepId), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        ProjectMemberResponseList response = this.httpClient.get(builtUrl, new HttpRequestConfig(queryParams), ProjectMemberResponseList.class);
        return ProjectMemberResponseList.to(response);
    }

    public ProjectMembersResponse addProjectMember(Long projectId, AddProjectMemberRequest request) throws HttpException, HttpBadRequestException {
        return this.httpClient.post(this.url + "/projects/" + projectId + "/members", request, new HttpRequestConfig(), ProjectMembersResponse.class);
    }

    public ResponseObject<ProjectMember> getProjectMemberPermissions(Long projectId, Long memberId) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/members/%d", this.url, projectId, memberId);
        ProjectMemberResponseObject response = this.httpClient.get(builtUrl, new HttpRequestConfig(), ProjectMemberResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public ResponseObject<ProjectMember> replaceProjectMemberPermissions(Long projectId, Long memberId, ReplaceProjectMemberPermissionsRequest request) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/members/%d", this.url, projectId, memberId);
        ProjectMemberResponseObject response = this.httpClient.put(builtUrl, request, new HttpRequestConfig(), ProjectMemberResponseObject.class);
        return ResponseObject.of(response.getData());
    }

    public void deleteMemberFromProject(Long projectId, Long memberId) throws HttpException, HttpBadRequestException {
        String builtUrl = String.format("%s/projects/%d/members/%d", this.url, projectId, memberId);
        this.httpClient.delete(builtUrl, new HttpRequestConfig(), Void.class);
    }

    public ResponseList<User> listUsers(Status status, String search, TwoFactor twoFactor, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("status", Optional.ofNullable(status), "search", Optional.ofNullable(search), "twoFactor", Optional.ofNullable(twoFactor), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        UserResponseList userResponseList = this.httpClient.get(this.url + "/users", new HttpRequestConfig(queryParams), UserResponseList.class);
        return UserResponseList.to(userResponseList);
    }

    public ResponseObject<User> inviteUser(InviteUserRequest request) throws HttpException, HttpBadRequestException {
        UserResponseObject invitedUserResponseObject = this.httpClient.post(this.url + "/users", request, new HttpRequestConfig(), UserResponseObject.class);
        return ResponseObject.of(invitedUserResponseObject.getData());
    }

    public ResponseObject<User> getUser(Long userId) throws HttpException, HttpBadRequestException {
        UserResponseObject languageResponseObject = this.httpClient.get(this.url + "/users/" + userId, new HttpRequestConfig(), UserResponseObject.class);
        return ResponseObject.of(languageResponseObject.getData());
    }

    public void deleteUser(Long userId) throws HttpException, HttpBadRequestException {
        this.httpClient.delete(this.url + "/users/" + userId, new HttpRequestConfig(), Void.class);
    }

    public ResponseObject<User> editUser(Long userId, List<PatchRequest> request) throws HttpException, HttpBadRequestException {
        UserResponseObject editedUserResponseObject = this.httpClient.patch(this.url + "/users/" + userId, request, new HttpRequestConfig(), UserResponseObject.class);
        return ResponseObject.of(editedUserResponseObject.getData());
    }

    public ResponseObject<User> getAuthenticatedUser() throws HttpException, HttpBadRequestException {
        UserResponseObject languageResponseObject = this.httpClient.get(this.url + "/user", new HttpRequestConfig(), UserResponseObject.class);
        return ResponseObject.of(languageResponseObject.getData());
    }

    public ResponseList<TeamMember> listProjectMembers(Long projectId, String search, Integer limit, Integer offset) throws HttpException, HttpBadRequestException {
        Map<String, Optional<Integer>> queryParams = HttpRequestConfig.buildUrlParams("search", Optional.ofNullable(search), "limit", Optional.ofNullable(limit), "offset", Optional.ofNullable(offset));
        TeamMemberResponseList teamMemberResponseList = this.httpClient.get(this.url + "/projects/" + projectId + "/members", new HttpRequestConfig(queryParams), TeamMemberResponseList.class);
        return TeamMemberResponseList.to(teamMemberResponseList);
    }

    public ResponseObject<TeamMember> getMemberInfo(Long projectId, Long memberId) throws HttpException, HttpBadRequestException {
        TeamMemberResponseObject teamMemberResponseObject = this.httpClient.get(this.url + "/projects/" + projectId + "/members/" + memberId, new HttpRequestConfig(), TeamMemberResponseObject.class);
        return ResponseObject.of(teamMemberResponseObject.getData());
    }
}

